/*
 * Decompiled with CFR 0.152.
 */
package fr.supermax_8.spawndecoration.manager;

import fr.supermax_8.spawndecoration.SpawnDecorationPlugin;
import fr.supermax_8.spawndecoration.utils.FileUtils;
import fr.supermax_8.spawndecoration.utils.SerializationMethods;
import fr.supermax_8.spawndecoration.utils.TemporaryListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RecordLocationManager {
    public static ConcurrentHashMap<String, List<Location>> records = new ConcurrentHashMap();

    public static List<String> toStringList(List<Location> locs) {
        ArrayList<String> list = new ArrayList<String>();
        for (Location loc : locs) {
            list.add(SerializationMethods.serializedLocation(loc));
        }
        return list;
    }

    public static List<Location> toLocationList(List<String> locs) {
        ArrayList<Location> list = new ArrayList<Location>();
        for (String loc : locs) {
            list.add(SerializationMethods.deserializedLocation(loc));
        }
        return list;
    }

    public static void load() {
        File recordDir = new File(SpawnDecorationPlugin.getInstance().getDataFolder(), "recordlocation");
        try {
            recordDir.mkdirs();
            for (File f : FileUtils.getFilesRecursively(recordDir)) {
                YamlConfiguration fc = YamlConfiguration.loadConfiguration((File)f);
                records.put(f.getName().replace(".yml", ""), RecordLocationManager.toLocationList(fc.getStringList("record")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startRecord(final Player p, String recordName) {
        p.sendMessage("\u00a76Starting record " + recordName + " \u00a77\u00a7lClick to end record !");
        final ArrayList locs = new ArrayList();
        BukkitTask run = new BukkitRunnable(){

            public void run() {
                locs.add(p.getLocation().clone());
                p.sendMessage("\u00a76Adding new Position: \u00a77" + p.getLocation());
            }
        }.runTaskTimer((Plugin)SpawnDecorationPlugin.getInstance(), 0L, 0L);
        new TemporaryListener<PlayerInteractEvent>(PlayerInteractEvent.class, EventPriority.NORMAL, e -> {
            if (!p.equals(e.getPlayer())) {
                return false;
            }
            try {
                File recordDir = new File(SpawnDecorationPlugin.getInstance().getDataFolder(), "recordlocation");
                File record = new File(recordDir, recordName + ".yml");
                if (!record.exists()) {
                    record.createNewFile();
                }
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)record);
                config.set("record", RecordLocationManager.toStringList(locs));
                config.save(record);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            p.sendMessage("\u00a76End record " + recordName);
            run.cancel();
            return true;
        });
    }
}

