/*
 * Decompiled with CFR 0.152.
 */
package fr.supermax_8.spawndecoration.commands;

import fr.supermax_8.spawndecoration.SpawnDecorationConfig;
import fr.supermax_8.spawndecoration.SpawnDecorationPlugin;
import fr.supermax_8.spawndecoration.manager.DecorationManager;
import fr.supermax_8.spawndecoration.manager.RecordLocationManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SpawnDecorationCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        try {
            if (!sender.hasPermission("spawndecoration.use")) {
                return false;
            }
            switch (args[0]) {
                case "record": {
                    CommandSender commandSender = sender;
                    if (!(commandSender instanceof Player)) {
                        sender.sendMessage("\u00a7cYou are not a player !");
                        return false;
                    }
                    Player p = (Player)commandSender;
                    RecordLocationManager.startRecord(p, args[1]);
                    break;
                }
                case "reload": {
                    sender.sendMessage("\u00a76SpawnDecoration Reload...");
                    SpawnDecorationConfig.reload();
                    sender.sendMessage("\u00a76SpawnDecoration Reload Done");
                }
            }
        }
        catch (Exception e) {
            this.sendHelp(sender);
        }
        return false;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(new String[]{"\u00a78[\u00a76SpawnDeocation\u00a78]", "\u00a77Version: " + SpawnDecorationPlugin.version, "\u00a77Records: " + RecordLocationManager.records.size(), "\u00a77Decorations: " + DecorationManager.map.size(), "\u00a7f- \u00a77/spawndecoration record <newRecordName>", "\u00a7f- \u00a77/spawndecoration reload"});
    }
}

