/*
 * Decompiled with CFR 0.152.
 */
package fr.supermax_8.spawndecoration;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import fr.supermax_8.spawndecoration.Metrics;
import fr.supermax_8.spawndecoration.SpawnDecorationConfig;
import fr.supermax_8.spawndecoration.commands.SpawnDecorationCommand;
import fr.supermax_8.spawndecoration.manager.DecorationManager;
import fr.supermax_8.spawndecoration.utils.TemporaryListener;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class SpawnDecorationPlugin
extends JavaPlugin {
    private static SpawnDecorationPlugin instance;
    public static String version;

    public void onEnable() {
        instance = this;
        version = this.getDescription().getVersion();
        Metrics metrics = new Metrics(this, 17158);
        metrics.addCustomChart(new Metrics.SingleLineChart("numberofdecoration", () -> DecorationManager.map.size()));
        if (Bukkit.getPluginManager().getPlugin("ModelEngine") == null) {
            Bukkit.getLogger().warning("Conversation | Plugin turn OFF ModelEngine is not on the server ! You should have ModelEngine to use this plugin !");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!ModelEngineAPI.api.getGenerator().isInitialized()) {
            new TemporaryListener<Event>(ModelRegistrationEvent.class, EventPriority.NORMAL, e -> {
                new BukkitRunnable(){

                    public void run() {
                        SpawnDecorationPlugin.this.loadModelEngineUsers();
                    }
                }.runTaskLater((Plugin)SpawnDecorationPlugin.getInstance(), 20L);
                return true;
            });
        } else {
            this.loadModelEngineUsers();
        }
        this.getCommand("spawndecoration").setExecutor((CommandExecutor)new SpawnDecorationCommand());
    }

    public void onDisable() {
        SpawnDecorationConfig.unLoad();
    }

    public void loadModelEngineUsers() {
        SpawnDecorationConfig.load();
    }

    public static SpawnDecorationPlugin getInstance() {
        return instance;
    }
}

