/*
 * Decompiled with CFR 0.152.
 */
package fr.supermax_8.spawndecoration;

import fr.supermax_8.spawndecoration.SpawnDecorationPlugin;
import fr.supermax_8.spawndecoration.blueprint.TrackDecoration;
import fr.supermax_8.spawndecoration.manager.DecorationManager;
import fr.supermax_8.spawndecoration.manager.RecordLocationManager;
import fr.supermax_8.spawndecoration.utils.FileUtils;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class SpawnDecorationConfig {
    public static void load() {
        RecordLocationManager.load();
        File pluginDir = SpawnDecorationPlugin.getInstance().getDataFolder();
        File decorationsDir = new File(pluginDir, "decorations");
        decorationsDir.mkdirs();
        for (File f : FileUtils.getFilesRecursively(decorationsDir)) {
            if (!f.getName().endsWith(".yml")) {
                return;
            }
            YamlConfiguration fc = YamlConfiguration.loadConfiguration((File)f);
            try {
                for (String key : fc.getKeys(false)) {
                    ConfigurationSection section = fc.getConfigurationSection(key);
                    DecorationManager.loadDecoration(key, section.getString("model"), section.getString("record"));
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("Error with file " + f.getName() + " !");
                e.printStackTrace();
            }
        }
    }

    public static void unLoad() {
        RecordLocationManager.records.clear();
        DecorationManager.map.values().forEach(TrackDecoration::end);
        DecorationManager.map.clear();
    }

    public static void reload() {
        SpawnDecorationConfig.unLoad();
        SpawnDecorationConfig.load();
    }
}

