/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.versions;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.merchant.MerchantRecipe;
import io.github.mrcomputer1.smileyplayertrader.versions.IMCVersion;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_15;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_16;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_16_R2;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_16_R3;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_17;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_18;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_18_R2;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_19;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_19_1;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_19_R2;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantInventory;

public class VersionSupport {
    private IMCVersion version;
    private static final List<VersionSupportMeta> supportedVersions = new ArrayList<VersionSupportMeta>();

    public static void registerSupportedVersion(Callable<Boolean> isSupported, Class<?> versionClass) {
        supportedVersions.add(new VersionSupportMeta(isSupported, versionClass));
    }

    private static IMCVersion getBoundVersion() {
        return SmileyPlayerTrader.getInstance().getVersionSupport().version;
    }

    public static ItemStack byteArrayToItemStack(byte[] array) throws InvocationTargetException {
        return VersionSupport.getBoundVersion().byteArrayToItemStack(array);
    }

    public static byte[] itemStackToByteArray(ItemStack itemStack) throws InvocationTargetException {
        return VersionSupport.getBoundVersion().itemStackToByteArray(itemStack);
    }

    public static void setRecipesOnMerchant(Merchant merchant, List<MerchantRecipe> recipes) throws InvocationTargetException {
        VersionSupport.getBoundVersion().setRecipesOnMerchant(merchant, recipes);
    }

    public static int getSpecialCountForRecipe(MerchantInventory inventory) throws InvocationTargetException {
        return VersionSupport.getBoundVersion().getSpecialCountForRecipe(inventory);
    }

    public void bindCompatibleVersion() throws IllegalStateException {
        if (this.version != null) {
            throw new IllegalStateException("Already bound version.");
        }
        String mcVersion = Bukkit.getBukkitVersion().split("-")[0];
        SmileyPlayerTrader.getInstance().getLogger().info("Bukkit version is '" + Bukkit.getBukkitVersion() + "', detected Minecraft version is '" + mcVersion + "'.");
        for (VersionSupportMeta version : supportedVersions) {
            try {
                if (!version.isSupported.call().booleanValue()) continue;
                this.version = (IMCVersion)version.versionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return;
            }
            catch (Exception ex) {
                SmileyPlayerTrader.getInstance().getLogger().warning("Unexpected exception in version support check, trying next version...");
                ex.printStackTrace();
            }
        }
        throw new IllegalStateException("No supported version was found.");
    }

    static {
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.15").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_15.class);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.16(\\.1)?-").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_16.class);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.16\\.[23]-").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_16_R2.class);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.16\\.[45]-").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_16_R3.class);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.17").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_17.class);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.18(\\.1)?-").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_18.class);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.18\\.2-").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_18_R2.class);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.19-").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_19.class);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.19\\.[12]-").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_19_1.class);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.19\\.[3-9]-").matcher(Bukkit.getBukkitVersion()).find(), MCVersion1_19_R2.class);
    }

    private static class VersionSupportMeta {
        public final Callable<Boolean> isSupported;
        public final Class<?> versionClass;

        public VersionSupportMeta(Callable<Boolean> isSupported, Class<?> versionClass) {
            this.isSupported = isSupported;
            this.versionClass = versionClass;
            if (!IMCVersion.class.isAssignableFrom(versionClass)) {
                throw new IllegalArgumentException("Version class does not implement IMCVersion.");
            }
        }
    }
}

