/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.database.statements;

import io.github.mrcomputer1.smileyplayertrader.util.database.AbstractDatabase;
import io.github.mrcomputer1.smileyplayertrader.util.database.MySQLDatabase;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.GenericStatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class MySQLStatementHandler
implements StatementHandler {
    private Map<StatementHandler.StatementType, String> statements = new HashMap<StatementHandler.StatementType, String>();
    private GenericStatementHandler generic;
    private AbstractDatabase database;

    public MySQLStatementHandler(MySQLDatabase db) {
        this.database = db;
        this.generic = new GenericStatementHandler(db);
        this.statements.put(StatementHandler.StatementType.CREATE_PRODUCT_TABLE, "CREATE TABLE IF NOT EXISTS $prefix$products (id INTEGER AUTO_INCREMENT PRIMARY KEY,merchant VARCHAR(36) NOT NULL,cost1 BLOB,cost2 BLOB,product BLOB,enabled BOOLEAN DEFAULT 0 NOT NULL,available BOOLEAN DEFAULT 0 NOT NULL,special_price INTEGER DEFAULT 0 NOT NULL,priority INTEGER DEFAULT 0 NOT NULL,stored_product INTEGER DEFAULT 0 NOT NULL,stored_cost INTEGER DEFAULT 0 NOT NULL,stored_cost2 INTEGER DEFAULT 0 NOT NULL,hide_on_out_of_stock INTEGER DEFAULT 0 NOT NULL,purchase_limit INTEGER DEFAULT -1 NOT NULL,purchase_count INTEGER DEFAULT 0 NOT NULL)");
        this.statements.put(StatementHandler.StatementType.CREATE_SETTINGS_TABLE, "CREATE TABLE IF NOT EXISTS $prefix$settings (player VARCHAR(36) PRIMARY KEY NOT NULL,trade_toggle BOOLEAN DEFAULT 1 NOT NULL,combat_notice_toggle BOOLEAN DEFAULT 1 NOT NULL)");
    }

    @Override
    public void run(StatementHandler.StatementType type, Object ... objs) {
        if (this.statements.containsKey((Object)type)) {
            String statement = this.statements.get((Object)type).replace("$prefix$", this.database.getDatabasePrefix());
            this.database.run(statement, objs);
        } else {
            this.generic.run(type, objs);
        }
    }

    @Override
    public ResultSet get(StatementHandler.StatementType type, Object ... objs) {
        if (this.statements.containsKey((Object)type)) {
            String statement = this.statements.get((Object)type).replace("$prefix$", this.database.getDatabasePrefix());
            return this.database.get(statement, objs);
        }
        return this.generic.get(type, objs);
    }
}

