/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.database.statements;

import io.github.mrcomputer1.smileyplayertrader.util.database.AbstractDatabase;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class GenericStatementHandler
implements StatementHandler {
    private Map<StatementHandler.StatementType, String> statements = new HashMap<StatementHandler.StatementType, String>();
    private AbstractDatabase database;

    public GenericStatementHandler(AbstractDatabase db) {
        this.database = db;
        this.statements.put(StatementHandler.StatementType.CREATE_META_TABLE, "CREATE TABLE IF NOT EXISTS $prefix$meta (sptversion INTEGER NOT NULL)");
        this.statements.put(StatementHandler.StatementType.ADD_PRODUCT, "INSERT INTO $prefix$products (merchant, product, cost1, cost2, enabled, available, special_price, priority, hide_on_out_of_stock) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.statements.put(StatementHandler.StatementType.FIND_PRODUCTS, "SELECT * FROM $prefix$products WHERE merchant=? ORDER BY priority DESC");
        this.statements.put(StatementHandler.StatementType.DELETE_PRODUCT, "DELETE FROM $prefix$products WHERE id=?");
        this.statements.put(StatementHandler.StatementType.SET_COST, "UPDATE $prefix$products SET cost1=?, special_price=0 WHERE id=?");
        this.statements.put(StatementHandler.StatementType.SET_SECONDARY_COST, "UPDATE $prefix$products SET cost2=? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.SET_PRODUCT, "UPDATE $prefix$products SET product=? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.ENABLE_PRODUCT, "UPDATE $prefix$products SET enabled=1, available=1 WHERE id=?");
        this.statements.put(StatementHandler.StatementType.DISABLE_PRODUCT, "UPDATE $prefix$products SET available=0 WHERE id=?");
        this.statements.put(StatementHandler.StatementType.GET_PRODUCT_BY_ID, "SELECT * FROM $prefix$products WHERE id=?");
        this.statements.put(StatementHandler.StatementType.FIND_PRODUCTS_IN_PAGES, "SELECT id, product, enabled, available FROM $prefix$products WHERE merchant=? ORDER BY priority DESC LIMIT ? OFFSET ?");
        this.statements.put(StatementHandler.StatementType.SET_PRODUCT_COST_COST2_SPECIALPRICE_PRIORITY_HIDEOUTOFSTOCK_PURCHASELIMIT, "UPDATE $prefix$products SET product=?, cost1=?, cost2=?, special_price=?, priority=?, hide_on_out_of_stock=?, purchase_limit=? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.GET_ENABLED, "SELECT enabled, available FROM $prefix$products WHERE id=?");
        this.statements.put(StatementHandler.StatementType.LOAD_PLAYER_CONFIG, "SELECT * FROM $prefix$settings WHERE player=?");
        this.statements.put(StatementHandler.StatementType.CREATE_DEFAULT_PLAYER_CONFIG, "INSERT INTO $prefix$settings (player) VALUES (?)");
        this.statements.put(StatementHandler.StatementType.UPDATE_PLAYER_CONFIG, "UPDATE $prefix$settings SET trade_toggle=?, combat_notice_toggle=? WHERE player=?");
        this.statements.put(StatementHandler.StatementType.HIDE_PRODUCT, "UPDATE $prefix$products SET enabled=0 WHERE id=?");
        this.statements.put(StatementHandler.StatementType.SET_DISCOUNT, "UPDATE $prefix$products SET special_price=? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.SET_PRIORITY, "UPDATE $prefix$products SET priority=? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.CHANGE_STORED_PRODUCT, "UPDATE $prefix$products SET stored_product=stored_product + ? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.CHANGE_STORED_COST, "UPDATE $prefix$products SET stored_cost=stored_cost + ? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.CHANGE_STORED_COST2, "UPDATE $prefix$products SET stored_cost2=stored_cost2 + ? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.SET_STORED_COST, "UPDATE $prefix$products SET stored_cost=? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.SET_STORED_COST2, "UPDATE $prefix$products SET stored_cost2=? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.FIND_PRODUCTS_WITH_EARNINGS, "SELECT * FROM $prefix$products WHERE merchant=? AND stored_cost>0 OR stored_cost2>0");
        this.statements.put(StatementHandler.StatementType.GET_UNCOLLECTED_EARNINGS, "SELECT COUNT(*) AS uncollected_earnings FROM $prefix$products WHERE merchant=? AND stored_cost>0 OR stored_cost2>0");
        this.statements.put(StatementHandler.StatementType.SET_HIDE_ON_OUT_OF_STOCK, "UPDATE $prefix$products SET hide_on_out_of_stock=? WHERE id=?");
        this.statements.put(StatementHandler.StatementType.FIND_ALL_PRODUCTS_IN_PAGES, "SELECT * FROM $prefix$products WHERE product IS NOT NULL AND cost1 IS NOT NULL AND enabled=1 AND available=1 LIMIT ? OFFSET ?");
        this.statements.put(StatementHandler.StatementType.INCREMENT_PURCHASE_COUNT, "UPDATE $prefix$products SET purchase_count=purchase_count + 1 WHERE id=?");
        this.statements.put(StatementHandler.StatementType.RESET_PURCHASE_COUNT, "UPDATE $prefix$products SET purchase_count=0 WHERE id=?");
        this.statements.put(StatementHandler.StatementType.SET_PURCHASE_LIMIT, "UPDATE $prefix$products SET purchase_limit=? WHERE id=?");
    }

    @Override
    public void run(StatementHandler.StatementType type, Object ... objs) {
        String statement = this.statements.get((Object)type).replace("$prefix$", this.database.getDatabasePrefix());
        this.database.run(statement, objs);
    }

    @Override
    public ResultSet get(StatementHandler.StatementType type, Object ... objs) {
        String statement = this.statements.get((Object)type).replace("$prefix$", this.database.getDatabasePrefix());
        return this.database.get(statement, objs);
    }
}

