/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.database;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.database.MySQLDatabase;
import io.github.mrcomputer1.smileyplayertrader.util.database.SQLiteDatabase;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.MySQLStatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.SQLiteStatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractDatabase {
    protected static int dbVersion = 6;

    public abstract long getInsertId();

    public abstract void run(String var1, Object ... var2);

    public abstract ResultSet get(String var1, Object ... var2);

    public abstract boolean isConnected();

    public abstract void close();

    public String getDatabasePrefix() {
        return SmileyPlayerTrader.getInstance().getConfiguration().getDatabasePrefix();
    }

    public StatementHandler getNewStatementHandler() {
        if (SmileyPlayerTrader.getInstance().getConfiguration().getDatabaseType().equals("sqlite")) {
            return new SQLiteStatementHandler((SQLiteDatabase)this);
        }
        if (SmileyPlayerTrader.getInstance().getConfiguration().getDatabaseType().equals("mysql")) {
            return new MySQLStatementHandler((MySQLDatabase)this);
        }
        return null;
    }

    public void upgrade() {
        ResultSet set = this.get("SELECT * FROM " + this.getDatabasePrefix() + "meta", new Object[0]);
        try {
            if (set.next()) {
                int ver = set.getInt("sptversion");
                if (ver < dbVersion) {
                    SmileyPlayerTrader.getInstance().getLogger().warning("Upgrading to database version " + dbVersion);
                    while (ver <= dbVersion) {
                        this.upgrade(ver);
                        ++ver;
                    }
                    SmileyPlayerTrader.getInstance().getLogger().warning("Upgraded to database version " + dbVersion);
                    this.run("UPDATE " + this.getDatabasePrefix() + "meta SET sptversion=?", dbVersion);
                } else if (ver > dbVersion) {
                    SmileyPlayerTrader.getInstance().getLogger().warning("You are loading a database meant for a newer plugin version!");
                }
            } else {
                this.run("INSERT INTO " + this.getDatabasePrefix() + "meta (sptversion) VALUES (?)", dbVersion);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected abstract void upgrade(int var1);
}

