/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.gui.productmanage;

import com.google.common.primitives.Ints;
import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUI;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUIComponent;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUIManager;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.component.SlotComponent;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.GUIItemSelector;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.ProductState;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PriceQuickSelectionComponent
extends GUIComponent {
    private static final ItemStack MORE_ITEMS_BTN = GUI.createItemWithLoreAndModify(Material.BEACON, 1, I18N.translate("&bMore Items...", new Object[0]), null, meta -> {
        meta.addEnchant(Enchantment.DURABILITY, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
    }, I18N.translate("&eShift Click to increase value", new Object[0]), I18N.translate("&eShift Right Click to decrease value", new Object[0]));
    private final List<ItemStack> itemStacks = new ArrayList<ItemStack>();
    private final SlotComponent priceSlot;
    private final ProductState state;
    private final boolean isPrimary;

    public PriceQuickSelectionComponent(int x, int y, SlotComponent priceSlot, ProductState state, boolean isPrimary) {
        super(x, y, 7, 1);
        this.priceSlot = priceSlot;
        List<ItemStack> quickSelectionStacks = SmileyPlayerTrader.getInstance().getConfiguration().getPriceQuickSelection();
        int stackCount = 0;
        for (ItemStack item : quickSelectionStacks) {
            if (stackCount++ >= 6) {
                SmileyPlayerTrader.getInstance().getLogger().warning("You have too many quick selection items.");
                break;
            }
            ItemStack stack = this.createQuickSelectionItem(item);
            if (stack == null) continue;
            this.itemStacks.add(stack);
        }
        this.itemStacks.add(MORE_ITEMS_BTN);
        this.state = state;
        this.isPrimary = isPrimary;
    }

    private ItemStack createQuickSelectionItem(ItemStack is) {
        if (is == null) {
            return null;
        }
        ItemMeta im = is.getItemMeta();
        assert (im != null);
        if (im.hasLore()) {
            List lore = im.getLore();
            assert (lore != null);
            lore.add("");
            lore.add(I18N.translate("&eClick to increase value", new Object[0]));
            lore.add(I18N.translate("&eRight Click to decrease value", new Object[0]));
            im.setLore(lore);
        } else {
            im.setLore(Arrays.asList(I18N.translate("&eClick to increase value", new Object[0]), I18N.translate("&eRight Click to decrease value", new Object[0])));
        }
        is.setItemMeta(im);
        return is;
    }

    private ItemStack getTrueItemStack(ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        assert (im != null);
        List lore = im.getLore();
        if (lore.size() == 2) {
            im.setLore(new ArrayList());
        } else {
            lore.remove(lore.size() - 1);
            lore.remove(lore.size() - 1);
            lore.remove(lore.size() - 1);
            im.setLore(lore);
        }
        ItemStack is = itemStack.clone();
        is.setItemMeta(im);
        return is;
    }

    @Override
    public void render(Inventory inventory) {
        switch (this.itemStacks.size()) {
            case 1: {
                inventory.setItem(this.y * 9 + 4, this.itemStacks.get(0));
                break;
            }
            case 2: {
                inventory.setItem(this.y * 9 + 3, this.itemStacks.get(0));
                inventory.setItem(this.y * 9 + 5, this.itemStacks.get(1));
                break;
            }
            case 3: {
                inventory.setItem(this.y * 9 + 2, this.itemStacks.get(0));
                inventory.setItem(this.y * 9 + 4, this.itemStacks.get(1));
                inventory.setItem(this.y * 9 + 6, this.itemStacks.get(2));
                break;
            }
            case 4: {
                inventory.setItem(this.y * 9 + 1, this.itemStacks.get(0));
                inventory.setItem(this.y * 9 + 3, this.itemStacks.get(1));
                inventory.setItem(this.y * 9 + 5, this.itemStacks.get(2));
                inventory.setItem(this.y * 9 + 7, this.itemStacks.get(3));
                break;
            }
            case 5: {
                inventory.setItem(this.y * 9 + 2, this.itemStacks.get(0));
                inventory.setItem(this.y * 9 + 3, this.itemStacks.get(1));
                inventory.setItem(this.y * 9 + 4, this.itemStacks.get(2));
                inventory.setItem(this.y * 9 + 5, this.itemStacks.get(3));
                inventory.setItem(this.y * 9 + 6, this.itemStacks.get(4));
                break;
            }
            case 6: {
                inventory.setItem(this.y * 9 + 1, this.itemStacks.get(0));
                inventory.setItem(this.y * 9 + 2, this.itemStacks.get(1));
                inventory.setItem(this.y * 9 + 3, this.itemStacks.get(2));
                inventory.setItem(this.y * 9 + 4, this.itemStacks.get(3));
                inventory.setItem(this.y * 9 + 5, this.itemStacks.get(4));
                inventory.setItem(this.y * 9 + 7, this.itemStacks.get(5));
                break;
            }
            case 7: {
                inventory.setItem(this.y * 9 + 1, this.itemStacks.get(0));
                inventory.setItem(this.y * 9 + 2, this.itemStacks.get(1));
                inventory.setItem(this.y * 9 + 3, this.itemStacks.get(2));
                inventory.setItem(this.y * 9 + 4, this.itemStacks.get(3));
                inventory.setItem(this.y * 9 + 5, this.itemStacks.get(4));
                inventory.setItem(this.y * 9 + 6, this.itemStacks.get(5));
                inventory.setItem(this.y * 9 + 7, this.itemStacks.get(6));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported amount of items");
            }
        }
        for (int i = this.y * 9; i < (this.y + 1) * 9; ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, GUI.BACKGROUND.clone());
        }
    }

    @Override
    public boolean onClick(ClickType type, int x, int y, Player player, ItemStack clickedStack) {
        if (clickedStack.equals((Object)GUI.BACKGROUND)) {
            return false;
        }
        if (clickedStack.equals((Object)MORE_ITEMS_BTN)) {
            if (type == ClickType.LEFT) {
                GUIManager.getInstance().openGui(player, new GUIItemSelector(this.state, this.isPrimary));
            } else if (type == ClickType.SHIFT_LEFT) {
                if (this.priceSlot.isChanged()) {
                    return false;
                }
                if (this.priceSlot.getItem() == null || this.priceSlot.getItem().getType().isAir()) {
                    return false;
                }
                this.priceSlot.getItem().setAmount(Ints.constrainToRange((int)(this.priceSlot.getItem().getAmount() + 1), (int)0, (int)this.priceSlot.getItem().getMaxStackSize()));
                this.priceSlot.updateItem(player, false);
            } else if (type == ClickType.SHIFT_RIGHT) {
                if (this.priceSlot.isChanged()) {
                    return false;
                }
                if (this.priceSlot.getItem() == null || this.priceSlot.getItem().getType().isAir()) {
                    return false;
                }
                this.priceSlot.getItem().setAmount(Ints.constrainToRange((int)(this.priceSlot.getItem().getAmount() - 1), (int)0, (int)this.priceSlot.getItem().getMaxStackSize()));
                this.priceSlot.updateItem(player, false);
            }
        } else if (type == ClickType.LEFT) {
            ItemStack trueItemStack = this.getTrueItemStack(clickedStack);
            if (this.priceSlot.getItem() == null || !this.priceSlot.getItem().isSimilar(trueItemStack) || this.priceSlot.isChanged()) {
                if (this.priceSlot.isChanged()) {
                    this.priceSlot.updateItem(player, true);
                }
                this.priceSlot.setItem(trueItemStack);
                this.priceSlot.updateItem(player, false);
            } else {
                this.priceSlot.getItem().setAmount(Ints.constrainToRange((int)(this.priceSlot.getItem().getAmount() + 1), (int)0, (int)this.priceSlot.getItem().getMaxStackSize()));
            }
        } else if (type == ClickType.RIGHT) {
            ItemStack trueItemStack = this.getTrueItemStack(clickedStack);
            if (this.priceSlot.getItem() == null || !this.priceSlot.getItem().isSimilar(trueItemStack) || this.priceSlot.isChanged()) {
                if (this.priceSlot.isChanged()) {
                    this.priceSlot.updateItem(player, true);
                }
                this.priceSlot.setItem(trueItemStack);
                this.priceSlot.updateItem(player, false);
            } else {
                this.priceSlot.getItem().setAmount(Ints.constrainToRange((int)(this.priceSlot.getItem().getAmount() - 1), (int)0, (int)this.priceSlot.getItem().getMaxStackSize()));
            }
        }
        return false;
    }
}

