/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.gui;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUI;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUIManager;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.component.BackgroundComponent;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.component.ButtonComponent;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.component.ItemGridComponent;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.component.LabelComponent;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.GUIDeleteProduct;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.GUIEnableDisableProduct;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.GUIItemStorage;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.GUIProduct;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.ProductState;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemUtil;
import io.github.mrcomputer1.smileyplayertrader.util.merchant.MerchantUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GUIProductList
extends GUI {
    private static final NamespacedKey PRODUCT_ID_KEY = new NamespacedKey((Plugin)SmileyPlayerTrader.getInstance(), "product_id");
    private final OfflinePlayer target;
    private final int page;
    private final boolean isMine;
    private final ButtonComponent collectEarningsBtn;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GUIProductList(OfflinePlayer target, int page, boolean isMine) {
        block13: {
            super(isMine ? I18N.translate("&2My Products (Page %0%)", page + 1) : I18N.translate("&2%0%'s Products (Page %1%)", target.getName(), page + 1), 6);
            this.target = target;
            this.page = page;
            this.isMine = isMine;
            this.addChild(new BackgroundComponent(0, 5, 9, 1, Material.IRON_BARS, 1, ChatColor.RESET.toString(), new String[0]));
            ItemGridComponent itemGrid = new ItemGridComponent(1, 1, 7, 4);
            itemGrid.setOnClickEvent(this::onProductClick);
            this.loadItems(itemGrid);
            this.addChild(itemGrid);
            if (SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageEnabled() && this.isMine) {
                this.collectEarningsBtn = new ButtonComponent(0, 5, Material.CHEST, 1, I18N.translate("&eCollect All Earnings", new Object[0]), new String[0]);
                this.collectEarningsBtn.setOnClickEvent(this::onCollectEarningsClick);
                this.addChild(this.collectEarningsBtn);
                try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_UNCOLLECTED_EARNINGS, this.target.getUniqueId().toString());){
                    if (set.next() && set.getInt("uncollected_earnings") > 0) {
                        this.collectEarningsBtn.getLore().add(I18N.translate("&a&l&k# &r&a&lUncollected Earnings &a&l&k#", new Object[0]));
                    }
                    break block13;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            this.collectEarningsBtn = null;
        }
        if (this.isMine) {
            ButtonComponent previewBtn = new ButtonComponent(8, 5, Material.VILLAGER_SPAWN_EGG, 1, I18N.translate("&aPreview Store", new Object[0]), new String[0]);
            previewBtn.setOnClickEvent(this::onPreviewClick);
            this.addChild(previewBtn);
        }
        if (this.page == 0) {
            this.addChild(new LabelComponent(3, 5, Material.RED_STAINED_GLASS_PANE, 1, I18N.translate("&cNo previous page.", new Object[0]), new String[0]));
        } else {
            ButtonComponent previousBtn = new ButtonComponent(3, 5, Material.ARROW, 1, I18N.translate("&aPrevious Page", new Object[0]), new String[0]);
            previousBtn.setOnClickEvent(this::onPreviousClick);
            this.addChild(previousBtn);
        }
        ButtonComponent nextBtn = new ButtonComponent(5, 5, Material.ARROW, 1, I18N.translate("&aNext Page", new Object[0]), new String[0]);
        nextBtn.setOnClickEvent(this::onNextClick);
        this.addChild(nextBtn);
        ButtonComponent createBtn = new ButtonComponent(4, 5, Material.EMERALD, 1, I18N.translate("&aCreate New Product", new Object[0]), new String[0]);
        createBtn.setOnClickEvent(this::onCreateClick);
        this.addChild(createBtn);
    }

    private void loadItems(ItemGridComponent grid) {
        try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.FIND_PRODUCTS_IN_PAGES, this.target.getUniqueId().toString(), 28, this.page * 28);){
            while (set.next()) {
                byte[] product = set.getBytes("product");
                ItemStack is = product == null ? new ItemStack(Material.BARRIER) : MerchantUtil.buildItem(product);
                assert (is != null);
                ItemMeta im = is.getItemMeta();
                assert (im != null);
                im.getPersistentDataContainer().set(PRODUCT_ID_KEY, PersistentDataType.INTEGER, (Object)set.getInt("id"));
                if (product == null) {
                    im.setDisplayName(I18N.translate("&cProduct Not Set!", new Object[0]));
                }
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(I18N.translate("&eProduct ID: ", new Object[0]) + set.getInt("id"));
                lore.add(I18N.translate("&bClick to &lEdit", new Object[0]));
                if (set.getBoolean("enabled") && set.getBoolean("available")) {
                    lore.add(I18N.translate("&bRight Click to &lDisable/Hide", new Object[0]));
                } else {
                    lore.add(I18N.translate("&bRight Click to &lEnable/Show", new Object[0]));
                }
                if (SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageEnabled()) {
                    lore.add(I18N.translate("&bShift Click to &lManage Stored Items", new Object[0]));
                }
                lore.add(I18N.translate("&bDrop to &lDelete", new Object[0]));
                im.setLore(lore);
                is.setItemMeta(im);
                grid.getItems().add(is);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean onProductClick(ClickType clickType, ItemStack itemStack) {
        if (itemStack == null) return false;
        if (itemStack.getType().isAir()) {
            return false;
        }
        int id = (Integer)itemStack.getItemMeta().getPersistentDataContainer().get(PRODUCT_ID_KEY, PersistentDataType.INTEGER);
        if (clickType == ClickType.LEFT) {
            GUIManager.getInstance().openGui(this.getPlayer(), new GUIProduct(new ProductState(this.page, this.target, this.isMine, id)));
            return false;
        }
        if (clickType == ClickType.DROP) {
            try (ResultSet set2 = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_PRODUCT_BY_ID, id);){
                if (!set2.next()) return false;
                if (set2.getInt("stored_product") > 0 || set2.getInt("stored_cost") > 0 || set2.getInt("stored_cost2") > 0) {
                    this.getPlayer().sendMessage(I18N.translate("&cYou must withdraw all stored product and earnings before deleting the product.", new Object[0]));
                    boolean bl = true;
                    return bl;
                }
                GUIManager.getInstance().openGui(this.getPlayer(), new GUIDeleteProduct(id, this.page, this.target, this.isMine));
                return false;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (clickType == ClickType.RIGHT) {
            try (ResultSet set3 = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_ENABLED, id);){
                if (!set3.next()) return false;
                boolean enable = !set3.getBoolean("enabled") || !set3.getBoolean("available");
                GUIManager.getInstance().openGui(this.getPlayer(), new GUIEnableDisableProduct(id, enable, this.page, this.target, this.isMine));
                return false;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (clickType != ClickType.SHIFT_LEFT) {
            if (clickType != ClickType.SHIFT_RIGHT) return false;
        }
        try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_PRODUCT_BY_ID, id);){
            if (!set.next()) return false;
            int stored = set.getInt("stored_product");
            byte[] productBytes = set.getBytes("product");
            if (productBytes == null) {
                boolean bl = false;
                return bl;
            }
            ItemStack productStack = MerchantUtil.buildItem(productBytes);
            GUIManager.getInstance().openGui(this.getPlayer(), new GUIItemStorage(id, stored, productStack, this.page, this.target, this.isMine));
            return false;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean onCreateClick(ClickType clickType) {
        GUIManager.getInstance().openGui(this.getPlayer(), new GUIProduct(new ProductState(this.page, this.target, this.isMine)));
        return false;
    }

    private boolean onNextClick(ClickType clickType) {
        GUIManager.getInstance().openGui(this.getPlayer(), new GUIProductList(this.target, this.page + 1, this.isMine));
        return false;
    }

    private boolean onPreviousClick(ClickType clickType) {
        GUIManager.getInstance().openGui(this.getPlayer(), new GUIProductList(this.target, this.page - 1, this.isMine));
        return false;
    }

    private boolean onCollectEarningsClick(ClickType clickType) {
        ItemUtil.collectEarnings(this.getPlayer());
        this.collectEarningsBtn.getLore().clear();
        this.refreshComponent(this.collectEarningsBtn);
        return false;
    }

    private boolean onPreviewClick(ClickType clickType) {
        MerchantUtil.openPreviewMerchant(this.getPlayer());
        return false;
    }
}

