/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.inventory.ItemStack;

public class SPTConfiguration {
    private final Configuration config;

    public SPTConfiguration(Configuration config) {
        this.config = config;
    }

    public List<String> getDisabledWorlds() {
        return this.config.getStringList("disabledWorlds");
    }

    public List<String> getStockLocations() {
        return this.config.getStringList("stockLocations");
    }

    public EnumAutoThanks getAutoThanksMode() {
        if (this.config.isBoolean("autoThanks")) {
            return this.config.getBoolean("autoThanks", true) ? EnumAutoThanks.SYSTEM_CHAT : EnumAutoThanks.NONE;
        }
        return EnumAutoThanks.getById(this.config.getString("autoThanks.mode", EnumAutoThanks.SYSTEM_CHAT.getId()));
    }

    public String getAutoThanksMessage() {
        String message = this.config.getString("autoThanks.message", "default");
        if (message.equalsIgnoreCase("default")) {
            return null;
        }
        return message;
    }

    public EnumAutoThanksMessageTarget getAutoThanksMessageTarget() {
        return EnumAutoThanksMessageTarget.getById(this.config.getString("autoThanks.target", "everyone"));
    }

    public String getCurrentLanguage() {
        return this.config.getString("currentLanguage", "en_us");
    }

    public String getDatabaseType() {
        return this.config.getString("database.type", "sqlite");
    }

    public String getDatabaseFile() {
        return this.config.getString("database.file", "database.db");
    }

    public String getDatabasePrefix() {
        return this.config.getString("database.prefix", "spt");
    }

    public String getDatabaseHost() {
        return this.config.getString("database.host");
    }

    public int getDatabasePort() {
        return this.config.getInt("database.port", 3306);
    }

    public String getDatabaseName() {
        return this.config.getString("database.name");
    }

    public String getDatabaseUsername() {
        return this.config.getString("database.username");
    }

    public String getDatabasePassword() {
        return this.config.getString("database.password");
    }

    public boolean getCheckForUpdatesEnabled() {
        return this.config.getBoolean("checkForUpdates", true);
    }

    public boolean getCheckForBugsEnabled() {
        return this.config.getBoolean("checkForBugs.check", false);
    }

    public boolean getCheckForBugsShouldDisable() {
        return this.config.getBoolean("checkForBugs.disable", false);
    }

    public boolean getUseGuiManager() {
        return this.config.getBoolean("useGuiManager", true);
    }

    public boolean getDisableRightClickTrading() {
        return this.config.getBoolean("disableRightClickTrading", false);
    }

    public boolean getItemStorageEnabled() {
        return this.config.getBoolean("itemStorage.enable", false);
    }

    public int getItemStorageProductStorageLimit() {
        return this.config.getInt("itemStorage.productStorageLimit", -1);
    }

    public boolean getItemStorageNotifyUncollectedEarningsEnabled() {
        return this.config.getBoolean("itemStorage.notifyUncollectedEarningsOnLogin", true);
    }

    public EnumOutOfStockBehaviour getOutOfStockBehaviour() {
        return EnumOutOfStockBehaviour.getById(this.config.getString("outOfStockBehaviour", EnumOutOfStockBehaviour.SHOW_BY_DEFAULT.getId()));
    }

    public boolean getAutoCombatLockEnabled() {
        return this.config.getBoolean("autoCombatLock.enabled", true);
    }

    public int getAutoCombatLockLength() {
        return this.config.getInt("autoCombatLock.combatLockLength", 30);
    }

    public boolean getAutoCombatLockNeverShowNotice() {
        return this.config.getBoolean("autoCombatLock.neverShowNotice", false);
    }

    public List<ItemStack> getPriceQuickSelection() {
        List priceQuickSelection = SmileyPlayerTrader.getInstance().getConfig().getList("priceQuickSelection", new ArrayList());
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Object itemObject : priceQuickSelection) {
            try {
                LinkedHashMap item = (LinkedHashMap)itemObject;
                ItemStack stack = ItemUtil.buildConfigurationItem(item);
                if (stack == null) continue;
                stacks.add(stack);
            }
            catch (ClassCastException ex) {
                SmileyPlayerTrader.getInstance().getLogger().severe("Failed to parse price quick selection item.");
            }
        }
        return stacks;
    }

    public boolean getPriceSelectorMenuAutomaticAddVanilla() {
        return this.config.getBoolean("priceSelectorMenu.automaticAdd.vanilla", true);
    }

    public List<String> getPriceSelectorMenuHiddenItems() {
        return this.config.getStringList("priceSelectorMenu.hiddenItems");
    }

    public List<ItemStack> getPriceSelectorMenuExtraItems() {
        List extraItems = SmileyPlayerTrader.getInstance().getConfig().getList("priceSelectorMenu.extraItems", new ArrayList());
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Object itemObject : extraItems) {
            try {
                LinkedHashMap item = (LinkedHashMap)itemObject;
                ItemStack stack = ItemUtil.buildConfigurationItem(item);
                if (stack == null) continue;
                stacks.add(stack);
            }
            catch (ClassCastException ex) {
                SmileyPlayerTrader.getInstance().getLogger().severe("Failed to parse price selector menu extra item.");
            }
        }
        return stacks;
    }

    public List<ItemStack> getPriceSelectorMenuFeaturedItems() {
        List featuredItems = SmileyPlayerTrader.getInstance().getConfig().getList("priceSelectorMenu.featuredItems", new ArrayList());
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Object itemObject : featuredItems) {
            try {
                LinkedHashMap item = (LinkedHashMap)itemObject;
                ItemStack stack = ItemUtil.buildConfigurationItem(item);
                if (stack == null) continue;
                stacks.add(stack);
            }
            catch (ClassCastException ex) {
                SmileyPlayerTrader.getInstance().getLogger().severe("Failed to parse price selector menu featured item.");
            }
        }
        return stacks;
    }

    public boolean getDebugSelfTrading() {
        return this.config.getBoolean("debugSelfTrading", false);
    }

    public boolean getDebugI18NAlerts() {
        return this.config.getBoolean("debugI18NAlerts", false);
    }

    public static enum EnumAutoThanks {
        PLAYER_CHAT("player_chat"),
        SYSTEM_CHAT("system_chat"),
        NONE("none");

        private static final Map<String, EnumAutoThanks> autoThanksModes;
        private final String id;

        public static EnumAutoThanks getById(String id) {
            if (id == null) {
                return SYSTEM_CHAT;
            }
            EnumAutoThanks mode = autoThanksModes.get(id.toLowerCase());
            return mode == null ? SYSTEM_CHAT : mode;
        }

        private EnumAutoThanks(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        static {
            autoThanksModes = new HashMap<String, EnumAutoThanks>();
            for (EnumAutoThanks mode : EnumAutoThanks.values()) {
                autoThanksModes.put(mode.id.toLowerCase(), mode);
            }
        }
    }

    public static enum EnumAutoThanksMessageTarget {
        EVERYONE("everyone"),
        CUSTOMER("customer"),
        MERCHANT("merchant"),
        INVOLVED("involved");

        private static final Map<String, EnumAutoThanksMessageTarget> autoThanksTargets;
        private final String id;

        public static EnumAutoThanksMessageTarget getById(String id) {
            if (id == null) {
                return EVERYONE;
            }
            EnumAutoThanksMessageTarget target = autoThanksTargets.get(id.toLowerCase());
            return target == null ? EVERYONE : target;
        }

        private EnumAutoThanksMessageTarget(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        static {
            autoThanksTargets = new HashMap<String, EnumAutoThanksMessageTarget>();
            for (EnumAutoThanksMessageTarget target : EnumAutoThanksMessageTarget.values()) {
                autoThanksTargets.put(target.id.toLowerCase(), target);
            }
        }
    }

    public static enum EnumOutOfStockBehaviour {
        SHOW_BY_DEFAULT("showByDefault"),
        HIDE_BY_DEFAULT("hideByDefault"),
        SHOW("show"),
        HIDE("hide");

        private static final Map<String, EnumOutOfStockBehaviour> behaviours;
        private final String id;

        public static EnumOutOfStockBehaviour getById(String id) {
            if (id == null) {
                return SHOW_BY_DEFAULT;
            }
            EnumOutOfStockBehaviour behaviour = behaviours.get(id.toLowerCase());
            return behaviour == null ? SHOW_BY_DEFAULT : behaviour;
        }

        private EnumOutOfStockBehaviour(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        static {
            behaviours = new HashMap<String, EnumOutOfStockBehaviour>();
            for (EnumOutOfStockBehaviour behaviour : EnumOutOfStockBehaviour.values()) {
                behaviours.put(behaviour.id.toLowerCase(), behaviour);
            }
        }
    }
}

