/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemUtil;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.StockLocations;
import io.github.mrcomputer1.smileyplayertrader.util.merchant.MerchantUtil;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;

public class EventListener
implements Listener {
    @EventHandler
    public void onEntityRightClick(PlayerInteractAtEntityEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (SmileyPlayerTrader.getInstance().getConfiguration().getDisableRightClickTrading()) {
            return;
        }
        if (e.getRightClicked().hasMetadata("NPC")) {
            return;
        }
        if (!e.getPlayer().hasPermission("smileyplayertrader.trade")) {
            return;
        }
        if (!SmileyPlayerTrader.getInstance().getPlayerConfig().getPlayer((Player)e.getPlayer()).tradeToggle || SmileyPlayerTrader.getInstance().getPlayerConfig().isLocked(e.getPlayer())) {
            return;
        }
        if (e.getRightClicked().getType() == EntityType.PLAYER) {
            Player store = (Player)e.getRightClicked();
            MerchantUtil.openMerchant(e.getPlayer(), (OfflinePlayer)store, false, false);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getView().getType() == InventoryType.MERCHANT) {
            if (e.getView().getTitle().startsWith(I18N.translate("&2Villager Store: ", new Object[0])) && e.getRawSlot() == 2) {
                long productId;
                OfflinePlayer store;
                MerchantInventory mi;
                block44: {
                    if (e.getClick() == ClickType.SHIFT_LEFT || e.getClick() == ClickType.SHIFT_RIGHT) {
                        e.setCancelled(true);
                        return;
                    }
                    mi = (MerchantInventory)e.getInventory();
                    store = Bukkit.getOfflinePlayer((String)e.getView().getTitle().replace(I18N.translate("&2Villager Store: ", new Object[0]), ""));
                    if (!store.isOnline() && !StockLocations.canTradeWithPlayer(store)) {
                        e.getWhoClicked().sendMessage(I18N.translate("&cYou cannot trade with offline players.", new Object[0]));
                        e.setCancelled(true);
                        return;
                    }
                    if (mi.getSelectedRecipe() == null) {
                        return;
                    }
                    productId = MerchantUtil.getProductId((Player)e.getWhoClicked(), mi.getSelectedRecipe().getResult());
                    try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_PRODUCT_BY_ID, productId);){
                        if (set.next()) {
                            ItemStack cost2;
                            if (!set.getBoolean("enabled") || !set.getBoolean("available")) {
                                e.getWhoClicked().sendMessage(I18N.translate("&cThis product is no longer for sale.", new Object[0]));
                                e.setCancelled(true);
                                return;
                            }
                            byte[] productBytes = set.getBytes("product");
                            if (productBytes == null) {
                                e.getWhoClicked().sendMessage(I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
                                e.setCancelled(true);
                                return;
                            }
                            ItemStack product = VersionSupport.byteArrayToItemStack(productBytes);
                            if (product == null || !product.equals((Object)mi.getSelectedRecipe().getResult())) {
                                e.getWhoClicked().sendMessage(I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
                                e.setCancelled(true);
                                return;
                            }
                            byte[] cost1Bytes = set.getBytes("cost1");
                            if (cost1Bytes == null) {
                                e.getWhoClicked().sendMessage(I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
                                e.setCancelled(true);
                                return;
                            }
                            ItemStack cost1 = VersionSupport.byteArrayToItemStack(cost1Bytes);
                            if (cost1 == null || !cost1.equals(mi.getSelectedRecipe().getIngredients().get(0))) {
                                e.getWhoClicked().sendMessage(I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
                                e.setCancelled(true);
                                return;
                            }
                            byte[] cost2Bytes = set.getBytes("cost2");
                            if (cost2Bytes == null && mi.getSelectedRecipe().getIngredients().size() >= 2) {
                                e.getWhoClicked().sendMessage(I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
                                e.setCancelled(true);
                                return;
                            }
                            if (!(cost2Bytes == null || (cost2 = VersionSupport.byteArrayToItemStack(cost2Bytes)) != null && cost2.equals(mi.getSelectedRecipe().getIngredients().get(1)))) {
                                e.getWhoClicked().sendMessage(I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
                                e.setCancelled(true);
                                return;
                            }
                            int discount = -set.getInt("special_price");
                            if (discount != VersionSupport.getSpecialCountForRecipe(mi)) {
                                e.getWhoClicked().sendMessage(I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
                                e.setCancelled(true);
                                return;
                            }
                            int purchaseLimit = set.getInt("purchase_limit");
                            int purchaseCount = set.getInt("purchase_count");
                            if (purchaseLimit != -1 && purchaseCount >= purchaseLimit) {
                                e.getWhoClicked().sendMessage(I18N.translate("&cThis product is no longer for sale.", new Object[0]));
                                e.setCancelled(true);
                                return;
                            }
                            break block44;
                        }
                        e.getWhoClicked().sendMessage(I18N.translate("&cThis product is no longer for sale.", new Object[0]));
                        e.setCancelled(true);
                        return;
                    }
                    catch (InvocationTargetException | SQLException ex) {
                        ex.printStackTrace();
                        e.setCancelled(true);
                        return;
                    }
                }
                if (ItemUtil.doesPlayerHaveItem(store, mi.getSelectedRecipe().getResult(), productId)) {
                    ItemUtil.removeStock(store, mi.getSelectedRecipe().getResult(), productId);
                    try {
                        ItemUtil.giveEarnings(store, mi.getSelectedRecipe(), VersionSupport.getSpecialCountForRecipe(mi), productId);
                    }
                    catch (InvocationTargetException ex) {
                        ex.printStackTrace();
                        SmileyPlayerTrader.getInstance().getLogger().severe("Something went wrong while attempting to give earnings to " + store.getName());
                    }
                    MerchantUtil.thankPurchaser(store, (Player)e.getWhoClicked());
                    SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.INCREMENT_PURCHASE_COUNT, productId);
                    if (store.isOnline()) {
                        store.getPlayer().sendMessage(I18N.translate("&a%0% just purchased %1%!", e.getWhoClicked().getName(), mi.getSelectedRecipe().getResult().getType()));
                    }
                    try {
                        if (!ItemUtil.doesPlayerHaveItem(store, mi.getSelectedRecipe().getResult(), productId)) {
                            if (store.isOnline()) {
                                store.getPlayer().sendMessage(I18N.translate("&c%0% is now out of stock!", mi.getSelectedRecipe().getResult().getType()));
                            }
                            ItemStack cost1 = e.getInventory().getItem(0);
                            ItemStack cost2 = e.getInventory().getItem(1);
                            cost1.setAmount(cost1.getAmount() - ItemUtil.computeAdjustedPrice(mi.getSelectedRecipe(), VersionSupport.getSpecialCountForRecipe(mi)));
                            if (mi.getSelectedRecipe().getIngredients().size() >= 2) {
                                cost2.setAmount(cost2.getAmount() - ((ItemStack)mi.getSelectedRecipe().getIngredients().get(1)).getAmount());
                            }
                            MerchantUtil.openMerchant((Player)e.getWhoClicked(), store, true, true);
                            InventoryView iv = e.getWhoClicked().getOpenInventory();
                            iv.setCursor(mi.getSelectedRecipe().getResult());
                        }
                    }
                    catch (InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    e.getWhoClicked().sendMessage(I18N.translate("&cThis item is out of stock!", new Object[0]));
                    e.setCancelled(true);
                }
            } else if (e.getView().getTitle().startsWith(I18N.translate("&2Preview Store: ", new Object[0])) && e.getRawSlot() == 2) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (e.getView().getType() == InventoryType.MERCHANT) {
            MerchantUtil.clearProductIdCache((Player)e.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (e.getPlayer().hasPermission("smileyplayertrader.admin") && SmileyPlayerTrader.getInstance().getUpdateChecker() != null) {
            if (SmileyPlayerTrader.getInstance().getUpdateChecker().unsupported) {
                e.getPlayer().sendMessage(I18N.translate("&c[Smiley Player Trader] This Minecraft version is no longer supported and therefore no support will be given for this version.", new Object[0]));
            }
            if (SmileyPlayerTrader.getInstance().getUpdateChecker().failed) {
                e.getPlayer().sendMessage(I18N.translate("&e[Smiley Player Trader] Failed to check plugin version!", new Object[0]));
            }
            if (SmileyPlayerTrader.getInstance().getUpdateChecker().isOutdated) {
                e.getPlayer().sendMessage(I18N.translate("&e[Smiley Player Trader] Plugin is outdated! Latest version is %0%. It is recommended to download the update.", SmileyPlayerTrader.getInstance().getUpdateChecker().upToDateVersion));
            }
        }
        if (SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageEnabled() && SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageNotifyUncollectedEarningsEnabled()) {
            try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_UNCOLLECTED_EARNINGS, e.getPlayer().getUniqueId().toString());){
                if (set.next() && set.getInt("uncollected_earnings") > 0) {
                    e.getPlayer().sendMessage(I18N.translate("&2&oYou have uncollected earnings. Type &f&o/spt collect &2&oto collect.", new Object[0]));
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        SmileyPlayerTrader.getInstance().getPlayerConfig().loadPlayer(e.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        MerchantUtil.clearProductIdCache(e.getPlayer());
        SmileyPlayerTrader.getInstance().getPlayerConfig().unloadPlayer(e.getPlayer());
    }

    @EventHandler
    public void onEntityTakeDamageByEntity(EntityDamageByEntityEvent e) {
        if (SmileyPlayerTrader.getInstance().getConfiguration().getDisabledWorlds().contains(e.getEntity().getWorld().getName())) {
            return;
        }
        if (SmileyPlayerTrader.getInstance().getConfiguration().getAutoCombatLockEnabled()) {
            if (e.getDamager() instanceof Player) {
                SmileyPlayerTrader.getInstance().getPlayerConfig().lockPlayer((Player)e.getDamager());
            }
            if (e.getEntity() instanceof Player) {
                SmileyPlayerTrader.getInstance().getPlayerConfig().lockPlayer((Player)e.getEntity());
            }
        }
    }
}

