/*
 * Decompiled with CFR 0.152.
 */
package com.tiberiumfusion.tfbukkit.simplereferral;

import com.tiberiumfusion.tfbukkit.simplereferral.TimeCheckTask;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class Main
extends JavaPlugin
implements Listener {
    public static String prefix = "[SREF] ";
    public static String messageFront = ChatColor.DARK_RED + prefix + ChatColor.GRAY;
    public static DecimalFormat twoDecimals = new DecimalFormat("#.##");
    public static double config_ExpireHours = 0.0;
    public static boolean config_EnableMoneyRewardType = false;
    public static boolean config_EnableItemRewardType = false;
    public static boolean config_EnableXPRewardType = false;
    public static double config_ReferralCooldown = 0.0;
    public static boolean config_AnnounceExpiredReferrals = false;
    public static double config_MoneyReferrerRewardAmount = 0.0;
    public static double config_MoneyReferreeRewardAmount = 0.0;
    public static Material config_ItemReferrerRewardType = Material.DIRT;
    public static int config_ItemReferrerRewardAmount = 0;
    public static Material config_ItemReferreeRewardType = Material.DIRT;
    public static int config_ItemReferreeRewardAmount = 0;
    public static int config_XPReferrerRewardAmount = 0;
    public static int config_XPReferreeRewardAmount = 0;
    public static boolean config_EnablePermReward = false;
    public static String config_PermReward = "";
    public static int config_PermRewardCount = 0;
    private static Economy vaultEcon = null;
    private static Permission vaultPerms = null;
    private FileConfiguration savedata;
    public static HashMap<String, String> pendingReferrals = new HashMap();
    public static HashMap<String, Long> pendingReferralTimes = new HashMap();
    public static HashMap<String, Long> referralCooldowns = new HashMap();
    public static HashMap<String, ArrayList<String>> referralHistory = new HashMap();

    public void onEnable() {
        boolean ser = this.setupEconomy();
        this.setupPermissions();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.LoadFromConfig();
        if (!ser && config_EnableMoneyRewardType) {
            this.getLogger().severe(String.format("SimpleReferral cannot load as Vault-based economy was not found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.LoadFromSavedata();
        BukkitTask task = new TimeCheckTask(this).runTaskTimer((Plugin)this, 80L, 1200L);
        this.getLogger().info("SimpleReferral loaded");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        vaultEcon = (Economy)rsp.getProvider();
        return vaultEcon != null;
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        vaultPerms = (Permission)rsp.getProvider();
        return vaultPerms != null;
    }

    public void onDisable() {
        this.saveConfig();
        this.SaveToSavedata();
        pendingReferrals = null;
        this.getLogger().info("SimpleReferral unloaded");
    }

    private void LoadFromConfig() {
        this.reloadConfig();
        config_ExpireHours = this.getConfig().getDouble("ExpireHours");
        config_EnableMoneyRewardType = this.getConfig().getBoolean("EnableMoneyRewardType");
        config_EnableItemRewardType = this.getConfig().getBoolean("EnableItemRewardType");
        config_EnableXPRewardType = this.getConfig().getBoolean("EnableXPRewardType");
        config_ReferralCooldown = this.getConfig().getDouble("ReferralCooldown");
        config_AnnounceExpiredReferrals = this.getConfig().getBoolean("AnnounceExpiredReferrals");
        config_MoneyReferrerRewardAmount = this.getConfig().getDouble("MoneyReferrerRewardAmount");
        config_MoneyReferreeRewardAmount = this.getConfig().getDouble("MoneyReferreeRewardAmount");
        config_ItemReferrerRewardType = Material.getMaterial((String)this.getConfig().getString("ItemReferrerRewardType").toUpperCase());
        config_ItemReferrerRewardAmount = this.getConfig().getInt("ItemReferrerRewardAmount");
        config_ItemReferreeRewardType = Material.getMaterial((String)this.getConfig().getString("ItemReferreeRewardType").toUpperCase());
        config_ItemReferreeRewardAmount = this.getConfig().getInt("ItemReferreeRewardAmount");
        config_XPReferrerRewardAmount = this.getConfig().getInt("XPReferrerRewardAmount");
        config_XPReferreeRewardAmount = this.getConfig().getInt("XPReferreeRewardAmount");
        config_EnablePermReward = this.getConfig().getBoolean("EnablePermReward");
        config_PermReward = this.getConfig().getString("PermReward");
        config_PermRewardCount = this.getConfig().getInt("PermRewardCount");
        this.getLogger().info("SimpleReferral config loaded; ExpireHours is " + String.valueOf(config_ExpireHours) + "\nReferralCooldown is " + String.valueOf(config_ReferralCooldown) + "\nAnnounceExpiredReferrals is " + String.valueOf(config_AnnounceExpiredReferrals) + "\nEnableMoneyRewardType is " + String.valueOf(config_EnableMoneyRewardType) + "\nEnableItemRewardType is " + String.valueOf(config_EnableItemRewardType) + "\nEnableXPRewardType is " + String.valueOf(config_EnableXPRewardType) + "\nMoneyReferrerRewardAmount is " + String.valueOf(config_MoneyReferrerRewardAmount) + "\nMoneyReferreeRewardAmount is " + String.valueOf(config_MoneyReferreeRewardAmount) + "\nItemReferrerRewardType is " + String.valueOf(config_ItemReferrerRewardType) + "\nItemReferrerRewardAmount is " + String.valueOf(config_ItemReferrerRewardAmount) + "\nItemReferreeRewardType is " + String.valueOf(config_ItemReferreeRewardType) + "\nItemReferreeRewardAmount is " + String.valueOf(config_ItemReferreeRewardAmount) + "\nXPReferrerRewardAmount is " + String.valueOf(config_XPReferrerRewardAmount) + "\nXPReferreeRewardAmount is " + String.valueOf(config_XPReferreeRewardAmount) + "\nEnablePermReward is " + String.valueOf(config_EnablePermReward) + "\nPermReward is " + String.valueOf(config_PermReward) + "\nPermRewardCount is " + String.valueOf(config_PermRewardCount));
    }

    private void LoadFromSavedata() {
        this.savedata = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "savedata.yml"));
        pendingReferrals = this.savedata.contains("PendingReferrals") ? (HashMap)this.savedata.getConfigurationSection("PendingReferrals").getValues(false) : new HashMap();
        pendingReferralTimes = this.savedata.contains("PendingReferralTimes") ? (HashMap)this.savedata.getConfigurationSection("PendingReferralTimes").getValues(false) : new HashMap();
        referralCooldowns = this.savedata.contains("ReferralCooldowns") ? (HashMap)this.savedata.getConfigurationSection("ReferralCooldowns").getValues(false) : new HashMap();
        referralHistory = this.savedata.contains("ReferralHistory") ? (HashMap)this.savedata.getConfigurationSection("ReferralHistory").getValues(false) : new HashMap();
    }

    private void SaveToSavedata() {
        this.savedata.createSection("PendingReferrals", pendingReferrals);
        this.savedata.createSection("PendingReferralTimes", pendingReferralTimes);
        this.savedata.createSection("ReferralCooldowns", referralCooldowns);
        this.savedata.createSection("ReferralHistory", referralHistory);
        try {
            this.savedata.save(new File(this.getDataFolder(), "savedata.yml"));
        }
        catch (IOException e) {
            this.getLogger().warning("SimpleReferral could not save referral records information!");
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        Player referree = event.getPlayer();
        if (pendingReferrals.containsKey(referree.getName())) {
            String uuidOfReferrer = pendingReferrals.get(referree.getName());
            Player referrer = Bukkit.getPlayer((UUID)UUID.fromString(uuidOfReferrer));
            if (!referree.hasPlayedBefore()) {
                boolean noErrors = true;
                if (config_EnableMoneyRewardType) {
                    EconomyResponse r2;
                    EconomyResponse r = vaultEcon.depositPlayer((OfflinePlayer)referrer, config_MoneyReferrerRewardAmount);
                    if (!r.transactionSuccess()) {
                        noErrors = false;
                    }
                    if (!(r2 = vaultEcon.depositPlayer((OfflinePlayer)referree, config_MoneyReferreeRewardAmount)).transactionSuccess()) {
                        noErrors = false;
                    }
                }
                if (config_EnableItemRewardType) {
                    try {
                        referrer.getInventory().addItem(new ItemStack[]{new ItemStack(config_ItemReferrerRewardType, config_ItemReferrerRewardAmount)});
                    }
                    catch (Exception e) {
                        noErrors = false;
                    }
                    try {
                        referree.getInventory().addItem(new ItemStack[]{new ItemStack(config_ItemReferreeRewardType, config_ItemReferreeRewardAmount)});
                    }
                    catch (Exception e) {
                        noErrors = false;
                    }
                }
                if (config_EnableXPRewardType) {
                    try {
                        referrer.giveExp(config_XPReferrerRewardAmount);
                    }
                    catch (Exception e) {
                        noErrors = false;
                    }
                    try {
                        referree.giveExp(config_XPReferreeRewardAmount);
                    }
                    catch (Exception e) {
                        noErrors = false;
                    }
                }
                if (noErrors) {
                    String message = String.valueOf(messageFront) + "You were rewarded " + ChatColor.WHITE + "[ ";
                    if (config_EnableMoneyRewardType) {
                        message = String.valueOf(message) + ChatColor.WHITE + "$" + twoDecimals.format(config_MoneyReferreeRewardAmount) + ChatColor.GRAY + ", ";
                    }
                    if (config_EnableItemRewardType) {
                        message = String.valueOf(message) + ChatColor.WHITE + String.valueOf(config_ItemReferreeRewardAmount) + ChatColor.GRAY + " of item " + ChatColor.WHITE + config_ItemReferreeRewardType.toString() + ChatColor.GRAY + ", ";
                    }
                    if (config_EnableXPRewardType) {
                        message = String.valueOf(message) + ChatColor.WHITE + twoDecimals.format(config_XPReferreeRewardAmount) + " XP" + ChatColor.GRAY + ", ";
                    }
                    message = String.valueOf(message) + ChatColor.WHITE + "]" + ChatColor.GRAY + " for being referred by player " + ChatColor.WHITE + referrer.getName();
                    referree.sendMessage(message);
                    String message2 = String.valueOf(messageFront) + "You were rewarded " + ChatColor.WHITE + "[ ";
                    if (config_EnableMoneyRewardType) {
                        message2 = String.valueOf(message2) + ChatColor.WHITE + "$" + twoDecimals.format(config_MoneyReferrerRewardAmount) + ChatColor.GRAY + ", ";
                    }
                    if (config_EnableItemRewardType) {
                        message2 = String.valueOf(message2) + ChatColor.WHITE + String.valueOf(config_ItemReferrerRewardAmount) + ChatColor.GRAY + " of item " + ChatColor.WHITE + config_ItemReferrerRewardType.toString() + ChatColor.GRAY + ", ";
                    }
                    if (config_EnableXPRewardType) {
                        message2 = String.valueOf(message2) + ChatColor.WHITE + twoDecimals.format(config_XPReferrerRewardAmount) + " XP" + ChatColor.GRAY + ", ";
                    }
                    message2 = String.valueOf(message2) + ChatColor.WHITE + "]" + ChatColor.GRAY + " for referring player " + ChatColor.WHITE + referree.getName();
                    referrer.sendMessage(message2);
                } else {
                    referree.sendMessage(String.valueOf(messageFront) + "There was an error giving you your reward for being referred by player " + ChatColor.WHITE + referrer.getName() + ChatColor.GRAY + ". You may have received some parts (but not all) of your reward.");
                    referrer.sendMessage(String.valueOf(messageFront) + "There was an error giving you your reward for referring player " + ChatColor.WHITE + referree.getName() + ChatColor.GRAY + ". You may have received some parts (but not all) of your reward.");
                }
                ArrayList<String> referrals = referralHistory.get(referrer.getUniqueId().toString());
                if (referrals == null) {
                    referrals = new ArrayList();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
                Date timeNow = new Date(System.currentTimeMillis());
                referrals.add(String.valueOf(referree.getName()) + " @ " + dateFormat.format(timeNow));
                int referCount = referrals.size();
                referralHistory.put(referrer.getUniqueId().toString(), referrals);
                if (config_EnablePermReward && referCount == config_PermRewardCount) {
                    vaultPerms.playerAdd(referrer, config_PermReward);
                    referrer.sendMessage(String.valueOf(messageFront) + "You have successfully referred " + ChatColor.WHITE + config_PermRewardCount + ChatColor.GRAY + " players to this server. As a bonus reward, you've been granted the following permission: " + ChatColor.WHITE + config_PermReward);
                }
            } else {
                referree.sendMessage(String.valueOf(messageFront) + "You were referred by player " + ChatColor.WHITE + referrer.getName() + ChatColor.GRAY + ", but this is not the first time you have joined this server. Neither you nor " + ChatColor.WHITE + referrer.getName() + ChatColor.GRAY + " have been rewarded.");
                referrer.sendMessage(String.valueOf(messageFront) + "You referred player " + ChatColor.WHITE + referree.getName() + ChatColor.GRAY + ", but they have joined this server before you referred them. Neither you nor " + ChatColor.WHITE + referree.getName() + ChatColor.GRAY + " have been rewarded.");
            }
            pendingReferrals.remove(referree.getName());
            pendingReferralTimes.remove(referree.getName());
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("refer")) {
            if (args.length == 0) {
                sender.sendMessage(ChatColor.DARK_RED + prefix + ChatColor.GRAY + "You cannot run this command without any arguments!");
                return false;
            }
            if (args.length > 1) {
                sender.sendMessage(ChatColor.DARK_RED + prefix + ChatColor.GRAY + "Extra arguments present! Only expected 1.");
                return false;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command can only be run by an ingame player.");
            } else {
                Player p = (Player)sender;
                boolean onCooldown = true;
                long diff = 0L;
                if (referralCooldowns.containsKey(p.getUniqueId().toString())) {
                    long lastTime = referralCooldowns.get(p.getUniqueId().toString());
                    diff = System.currentTimeMillis() - lastTime;
                    if (diff > TimeUnit.SECONDS.toMillis((long)(config_ReferralCooldown * 60.0))) {
                        onCooldown = false;
                        referralCooldowns.remove(p.getUniqueId().toString());
                    }
                } else {
                    onCooldown = false;
                }
                if (!onCooldown) {
                    String friend = args[0];
                    if (p.getName().equals(friend)) {
                        sender.sendMessage(String.valueOf(messageFront) + "You cannot refer yourself!");
                        return true;
                    }
                    if (pendingReferrals.containsKey(friend)) {
                        sender.sendMessage(String.valueOf(messageFront) + "This player has already been referred!");
                        return true;
                    }
                    pendingReferrals.put(friend, p.getUniqueId().toString());
                    pendingReferralTimes.put(friend, System.currentTimeMillis());
                    String message = String.valueOf(messageFront) + "You have created a referral for player " + ChatColor.WHITE + friend + ChatColor.GRAY + ". The next player to join this server with that name will be rewarded " + ChatColor.WHITE + "[ ";
                    if (config_EnableMoneyRewardType) {
                        message = String.valueOf(message) + ChatColor.WHITE + "$" + twoDecimals.format(config_MoneyReferreeRewardAmount) + ChatColor.GRAY + ", ";
                    }
                    if (config_EnableItemRewardType) {
                        message = String.valueOf(message) + ChatColor.WHITE + String.valueOf(config_ItemReferreeRewardAmount) + ChatColor.GRAY + " of item " + ChatColor.WHITE + config_ItemReferreeRewardType.toString() + ChatColor.GRAY + ", ";
                    }
                    if (config_EnableXPRewardType) {
                        message = String.valueOf(message) + ChatColor.WHITE + twoDecimals.format(config_XPReferreeRewardAmount) + " XP" + ChatColor.GRAY + ", ";
                    }
                    message = String.valueOf(message) + ChatColor.WHITE + "]" + ChatColor.GRAY + " and you will be rewarded " + ChatColor.WHITE + "[ ";
                    if (config_EnableMoneyRewardType) {
                        message = String.valueOf(message) + ChatColor.WHITE + "$" + twoDecimals.format(config_MoneyReferrerRewardAmount) + ChatColor.GRAY + ", ";
                    }
                    if (config_EnableItemRewardType) {
                        message = String.valueOf(message) + ChatColor.WHITE + String.valueOf(config_ItemReferrerRewardAmount) + ChatColor.GRAY + " of item " + ChatColor.WHITE + config_ItemReferrerRewardType.toString() + ChatColor.GRAY + ", ";
                    }
                    if (config_EnableXPRewardType) {
                        message = String.valueOf(message) + ChatColor.WHITE + twoDecimals.format(config_XPReferrerRewardAmount) + " XP" + ChatColor.GRAY + ", ";
                    }
                    message = String.valueOf(message) + ChatColor.WHITE + "]";
                    sender.sendMessage(message);
                    sender.sendMessage(String.valueOf(messageFront) + "This referral will expire in " + ChatColor.WHITE + config_ExpireHours + ChatColor.GRAY + " hours.");
                    referralCooldowns.put(p.getUniqueId().toString(), System.currentTimeMillis());
                } else {
                    sender.sendMessage(String.valueOf(messageFront) + "You must wait another " + twoDecimals.format(config_ReferralCooldown - (double)TimeUnit.MILLISECONDS.toSeconds(diff) / 60.0) + " minutes before you can refer another player!");
                }
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("srefReload")) {
            if (args.length > 1) {
                sender.sendMessage(ChatColor.DARK_RED + prefix + ChatColor.GRAY + "This commmand does not use any arguments!");
                return false;
            }
            this.LoadFromConfig();
            sender.sendMessage(String.valueOf(messageFront) + "The SimpleReferral config has been reloaded. This action is not recommended at all!");
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("myrefer")) {
            if (args.length > 1) {
                sender.sendMessage(ChatColor.DARK_RED + prefix + ChatColor.GRAY + "This commmand does not use any arguments!");
                return false;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command can only be run by an ingame player.");
                return false;
            }
            Player p = (Player)sender;
            if (referralHistory.containsKey(p.getUniqueId().toString())) {
                ArrayList<String> referrals = referralHistory.get(p.getUniqueId().toString());
                if (referrals.size() > 0) {
                    sender.sendMessage(String.valueOf(messageFront) + "You have successfully referred the following " + referrals.size() + " players to this server:");
                    for (String entry : referrals) {
                        sender.sendMessage(String.valueOf(messageFront) + entry);
                    }
                } else {
                    sender.sendMessage(String.valueOf(messageFront) + "You have yet to successfully refer any players to this server!");
                }
            } else {
                sender.sendMessage(String.valueOf(messageFront) + "You have yet to successfully refer any players to this server!");
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("allrefer")) {
            if (args.length > 1) {
                sender.sendMessage(ChatColor.DARK_RED + prefix + ChatColor.GRAY + "This commmand does not use any arguments!");
                return false;
            }
            int count = 0;
            for (String playerUUID : referralHistory.keySet()) {
                Player p = Bukkit.getPlayer((UUID)UUID.fromString(playerUUID));
                ArrayList<String> entries = referralHistory.get(playerUUID);
                if (entries.size() <= 0) continue;
                sender.sendMessage(String.valueOf(messageFront) + "Player " + p.getName() + " has successfully referred:");
                for (String entry : entries) {
                    sender.sendMessage(String.valueOf(messageFront) + "  - " + entry);
                    ++count;
                }
            }
            sender.sendMessage(String.valueOf(messageFront) + "There have been " + count + " total successful referrals on this server.");
            return true;
        }
        return false;
    }
}

