/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.utilities.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.UUID;
import me.refracdevelopment.simplegems.SimpleGems;
import me.refracdevelopment.simplegems.data.ProfileData;
import me.refracdevelopment.simplegems.utilities.chat.Color;

public class PlayerMapper {
    private final String directory;
    private final JsonParser parser = new JsonParser();

    public PlayerMapper(String directory) {
        this.directory = directory;
        File folder = new File(directory);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!new File(directory).isDirectory()) {
            throw new IllegalArgumentException("The directory path is not an directory");
        }
    }

    public void loadPlayerFile(UUID uuid) {
        File playerFile = new File(this.directory + File.separator + uuid.toString() + ".json");
        if (!playerFile.exists()) {
            this.generateDefaultFile(uuid, SimpleGems.getInstance().getProfileManager().getProfile(uuid).getData().getName());
        }
        try {
            FileReader reader = new FileReader(this.directory + File.separator + uuid + ".json");
            JsonObject obj = (JsonObject)this.parser.parse((Reader)reader);
            reader.close();
            double gems = obj.get("gems").getAsDouble();
            SimpleGems.getInstance().getProfileManager().getProfile(uuid).getData().getGems().setAmount(gems);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void savePlayer(ProfileData player) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("uuid", player.getUuid().toString());
        jsonObject.addProperty("name", player.getName());
        jsonObject.addProperty("gems", (Number)player.getGems().getAmount());
        this.saveFile(player.getUuid(), jsonObject);
    }

    public void saveOfflinePlayer(UUID uuid, String name, double amount) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("uuid", uuid.toString());
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("gems", (Number)amount);
        this.saveFile(uuid, jsonObject);
    }

    private void generateDefaultFile(UUID uuid, String name) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("uuid", uuid.toString());
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("gems", (Number)0.0);
        this.saveFile(uuid, jsonObject);
    }

    private void saveFile(UUID uuid, JsonObject jsonObject) {
        File file = new File(this.directory + File.separator + uuid.toString() + ".json");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            Color.log("&cError while trying to create config file for user: " + uuid);
            e.printStackTrace();
        }
        try {
            FileWriter myWriter = new FileWriter(file);
            myWriter.write(jsonObject.toString());
            myWriter.close();
        }
        catch (IOException e) {
            Color.log("&cError while trying to create a printer for file for user: " + uuid);
            e.printStackTrace();
        }
    }

    public double getGems(UUID uuid) {
        try {
            FileReader reader = new FileReader(this.directory + File.separator + uuid + ".json");
            JsonObject obj = (JsonObject)this.parser.parse((Reader)reader);
            reader.close();
            return obj.get("gems").getAsDouble();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }
}

