/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringPlaceholders {
    private static final StringPlaceholders EMPTY = new StringPlaceholders(Collections.emptyMap(), "%", "%");
    private final String startDelimiter;
    private final String endDelimiter;
    private final Map<String, String> placeholders;

    private StringPlaceholders(Map<String, String> placeholders, String startDelimiter, String endDelimiter) {
        this.placeholders = Collections.unmodifiableMap(placeholders);
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
    }

    public String apply(String string) {
        for (String key : this.placeholders.keySet()) {
            string = string.replaceAll(Pattern.quote(this.startDelimiter + key + this.endDelimiter), Matcher.quoteReplacement(this.placeholders.get(key)));
        }
        return string;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String placeholder, Object value) {
        return new Builder().add(placeholder, value);
    }

    public static StringPlaceholders empty() {
        return EMPTY;
    }

    @Deprecated
    public static StringPlaceholders single(String placeholder, Object value) {
        return StringPlaceholders.builder(placeholder, value).build();
    }

    public static StringPlaceholders of(String placeholder, Object value) {
        return StringPlaceholders.builder(placeholder, value).build();
    }

    public static StringPlaceholders of(String placeholder1, Object value1, String placeholder2, Object value2) {
        return StringPlaceholders.builder(placeholder1, value1).add(placeholder2, value2).build();
    }

    public static StringPlaceholders of(String placeholder1, Object value1, String placeholder2, Object value2, String placeholder3, Object value3) {
        return StringPlaceholders.builder(placeholder1, value1).add(placeholder2, value2).add(placeholder3, value3).build();
    }

    public static StringPlaceholders of(String placeholder1, Object value1, String placeholder2, Object value2, String placeholder3, Object value3, String placeholder4, Object value4) {
        return StringPlaceholders.builder(placeholder1, value1).add(placeholder2, value2).add(placeholder3, value3).add(placeholder4, value4).build();
    }

    public static StringPlaceholders of(String placeholder1, Object value1, String placeholder2, Object value2, String placeholder3, Object value3, String placeholder4, Object value4, String placeholder5, Object value5) {
        return StringPlaceholders.builder(placeholder1, value1).add(placeholder2, value2).add(placeholder3, value3).add(placeholder4, value4).add(placeholder5, value5).build();
    }

    public static class Builder {
        private String startDelimiter = "%";
        private String endDelimiter = "%";
        private final Map<String, String> placeholders = new HashMap<String, String>();

        private Builder() {
        }

        public Builder add(String placeholder, Object value) {
            this.placeholders.put(placeholder, Objects.toString(value, "null"));
            return this;
        }

        @Deprecated
        public Builder addPlaceholder(String placeholder, Object value) {
            return this.add(placeholder, value);
        }

        public Builder delimiters(String startDelimiter, String endDelimiter) {
            this.startDelimiter = startDelimiter;
            this.endDelimiter = endDelimiter;
            return this;
        }

        public Builder addAll(StringPlaceholders placeholders) {
            return this.addAll(placeholders.getPlaceholders());
        }

        public Builder addAll(Map<String, String> placeholders) {
            this.placeholders.putAll(placeholders);
            return this;
        }

        public StringPlaceholders build() {
            return new StringPlaceholders(this.placeholders, this.startDelimiter, this.endDelimiter);
        }
    }
}

