/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedConfigurationSection;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedFileConfiguration;
import me.refracdevelopment.simplegems.rosegarden.config.RoseSettingSection;
import me.refracdevelopment.simplegems.rosegarden.config.RoseSettingValue;
import me.refracdevelopment.simplegems.rosegarden.utils.HexUtils;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public final class RoseGardenUtils {
    public static final String GRADIENT = "<g:#8A2387:#E94057:#F27121>";
    public static final String PREFIX = "&7[<g:#8A2387:#E94057:#F27121>RoseGarden&7] ";
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Character.TYPE, Character.class);
            this.put(Double.TYPE, Double.class);
            this.put(Float.TYPE, Float.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Short.TYPE, Short.class);
            this.put(Void.TYPE, Void.class);
        }
    };
    private static Logger logger;

    private RoseGardenUtils() {
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = new Logger("RoseGarden", null){};
            logger.setParent(Bukkit.getLogger());
            logger.setLevel(Level.ALL);
        }
        return logger;
    }

    public static boolean containsConfigSpecialCharacters(String string) {
        for (char c : string.toCharArray()) {
            if (c == '\n' || ' ' <= c && c <= '~' || !(c == '\u0085' || c >= '\u00a0' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            return true;
        }
        return false;
    }

    public static void recursivelyWriteRoseSettingValues(CommentedFileConfiguration fileConfiguration, RoseSettingValue settingValue) {
        RoseGardenUtils.recursivelyWriteRoseSettingValues(fileConfiguration, fileConfiguration, settingValue);
    }

    private static void recursivelyWriteRoseSettingValues(CommentedFileConfiguration baseConfiguration, CommentedConfigurationSection currentSection, RoseSettingValue settingValue) {
        String keyPath;
        String key = settingValue.getKey();
        Object defaultValue = settingValue.getDefaultValue();
        String[] comments = settingValue.getComments();
        String string = keyPath = currentSection.getCurrentPath() == null ? key : currentSection.getCurrentPath() + "." + key;
        if (defaultValue instanceof RoseSettingSection) {
            baseConfiguration.addPathedComments(keyPath, comments);
            currentSection = currentSection.createSection(key);
            RoseSettingSection settingSection = (RoseSettingSection)defaultValue;
            for (RoseSettingValue value : settingSection.getValues()) {
                RoseGardenUtils.recursivelyWriteRoseSettingValues(baseConfiguration, currentSection, value);
            }
        } else {
            baseConfiguration.set(keyPath, defaultValue, comments);
        }
    }

    public static double getNumber(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return (Double)value;
    }

    public static boolean isUpdateAvailable(String latest, String current) {
        int[] currentSplit;
        if (latest == null || current == null) {
            return false;
        }
        int[] latestSplit = Arrays.stream(latest.replaceAll("[^0-9.]", "").split(Pattern.quote("."))).mapToInt(Integer::parseInt).toArray();
        if (latestSplit.length > (currentSplit = Arrays.stream(current.replaceAll("[^0-9.]", "").split(Pattern.quote("."))).mapToInt(Integer::parseInt).toArray()).length) {
            currentSplit = Arrays.copyOf(currentSplit, latestSplit.length);
        } else if (currentSplit.length > latestSplit.length) {
            latestSplit = Arrays.copyOf(latestSplit, currentSplit.length);
        }
        for (int i = 0; i < latestSplit.length; ++i) {
            if (latestSplit[i] > currentSplit[i]) {
                return true;
            }
            if (currentSplit[i] > latestSplit[i]) break;
        }
        return false;
    }

    public static boolean isRelocated() {
        String defaultPackage = new String(new byte[]{100, 101, 118, 46, 114, 111, 115, 101, 119, 111, 111, 100, 46, 114, 111, 115, 101, 103, 97, 114, 100, 101, 110});
        return !RosePlugin.class.getPackage().getName().equals(defaultPackage);
    }

    public static Class<?> getPrimitiveAsWrapper(Class<?> clazz) {
        return clazz.isPrimitive() ? PRIMITIVE_TO_WRAPPER.get(clazz) : clazz;
    }

    public static void sendMessage(CommandSender recipient, String message) {
        recipient.sendMessage(HexUtils.colorify(PREFIX + message));
    }

    public static void sendMessage(CommandSender recipient, String message, StringPlaceholders placeholders) {
        RoseGardenUtils.sendMessage(recipient, placeholders.apply(message));
    }
}

