/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.plugin.java.JavaPlugin;

public final class ClassUtils {
    private static JarFile getJar(JavaPlugin instance) {
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            File file = (File)method.invoke((Object)instance, new Object[0]);
            return new JarFile(file);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Class<T>> getClassesOf(JavaPlugin instance, String basePackage, Class<T> type) {
        JarFile jar = ClassUtils.getJar(instance);
        if (jar == null) {
            return new ArrayList<Class<T>>();
        }
        basePackage = basePackage.replace('.', '/') + "/";
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        try {
            Enumeration<JarEntry> jarEntry = jar.entries();
            while (jarEntry.hasMoreElements()) {
                String name = jarEntry.nextElement().getName();
                if (!name.startsWith(basePackage) || !name.endsWith(".class")) continue;
                String className = name.replace("/", ".").substring(0, name.length() - 6);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className, true, instance.getClass().getClassLoader());
                }
                catch (ClassNotFoundException | ExceptionInInitializerError e) {
                    e.printStackTrace();
                }
                if (clazz == null || !type.isAssignableFrom(clazz)) continue;
                classes.add(clazz);
            }
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return classes;
    }
}

