/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.manager;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedFileConfiguration;
import me.refracdevelopment.simplegems.rosegarden.manager.Manager;
import me.refracdevelopment.simplegems.rosegarden.utils.RoseGardenUtils;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PluginUpdateManager
extends Manager
implements Listener {
    private static final String[] SNAPSHOT_HEADER = new String[]{"================================================", " You are currently running a DEVELOPMENT BUILD!", " These types of builds are not meant to be run", " on a production server, and are not supported.", "================================================"};
    private boolean displayedSnapshotHeader;
    private String updateVersion;

    public PluginUpdateManager(RosePlugin rosePlugin) {
        super(rosePlugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.rosePlugin);
    }

    @Override
    public void reload() {
        File configFile = new File(this.rosePlugin.getRoseGardenDataFolder(), "config.yml");
        String currentVersion = this.rosePlugin.getDescription().getVersion();
        if (currentVersion.contains("-SNAPSHOT") && !this.displayedSnapshotHeader) {
            for (String line : SNAPSHOT_HEADER) {
                this.rosePlugin.getLogger().warning(line);
            }
            this.displayedSnapshotHeader = true;
            return;
        }
        CommentedFileConfiguration configuration = CommentedFileConfiguration.loadConfiguration(configFile);
        if (!configuration.contains("check-updates")) {
            configuration.set("check-updates", true, "Should all plugins running RoseGarden check for updates?", "RoseGarden is a core library created by Rosewood Development");
            configuration.save(configFile);
        }
        if (!configuration.getBoolean("check-updates") || this.rosePlugin.getSpigotId() == -1) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.rosePlugin, () -> {
            try {
                String latestVersion = this.getLatestVersion();
                if (RoseGardenUtils.isUpdateAvailable(latestVersion, currentVersion)) {
                    this.updateVersion = latestVersion;
                    RoseGardenUtils.getLogger().info("An update for " + this.rosePlugin.getName() + " (v" + this.updateVersion + ") is available! You are running v" + currentVersion + ".");
                }
            }
            catch (Exception e) {
                RoseGardenUtils.getLogger().warning("An error occurred checking for an update. There is either no established internet connection or the Spigot API is down.");
            }
        });
    }

    @Override
    public void disable() {
    }

    private String getLatestVersion() throws IOException {
        URL spigot = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.rosePlugin.getSpigotId());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(spigot.openStream()));){
            String string = reader.readLine();
            return string;
        }
    }

    public String getUpdateVersion() {
        return this.updateVersion;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.updateVersion == null || !player.isOp()) {
            return;
        }
        String website = this.rosePlugin.getDescription().getWebsite();
        String updateMessage = "&eAn update for <g:#8A2387:#E94057:#F27121>" + this.rosePlugin.getName() + " &e(&bv%new%&e) is available! You are running &bv%current%&e." + (website != null ? " " + website : "");
        StringPlaceholders placeholders = StringPlaceholders.builder("new", this.updateVersion).add("current", this.rosePlugin.getDescription().getVersion()).build();
        RoseGardenUtils.sendMessage((CommandSender)player, updateMessage, placeholders);
    }
}

