/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.manager;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.database.DataMigration;
import me.refracdevelopment.simplegems.rosegarden.database.DatabaseConnector;
import me.refracdevelopment.simplegems.rosegarden.database.SQLiteConnector;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractDataManager;
import me.refracdevelopment.simplegems.rosegarden.manager.Manager;
import me.refracdevelopment.simplegems.rosegarden.utils.RoseGardenUtils;

public class DataMigrationManager
extends Manager {
    private final List<DataMigration> migrations = new ArrayList<DataMigration>();

    public DataMigrationManager(RosePlugin rosePlugin) {
        super(rosePlugin);
        for (Class<? extends DataMigration> dataMigrationClass : rosePlugin.getManager(AbstractDataManager.class).getDataMigrations()) {
            try {
                this.migrations.add(dataMigrationClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (NoSuchMethodException ex) {
                RoseGardenUtils.getLogger().severe("DEVELOPER ERROR!!! DataMigration (" + dataMigrationClass.getSimpleName() + ") is missing a parameterless constructor!This is likely going to cause database issues, as this migration will not be registered!");
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void reload() {
        AbstractDataManager dataManager = this.rosePlugin.getManager(AbstractDataManager.class);
        DatabaseConnector databaseConnector = dataManager.getDatabaseConnector();
        databaseConnector.connect(connection -> {
            PreparedStatement statement;
            PreparedStatement statement2;
            boolean migrationsExist;
            int currentMigration = -1;
            String query = databaseConnector instanceof SQLiteConnector ? "SELECT 1 FROM sqlite_master WHERE type = 'table' AND name = ?" : "SHOW TABLES LIKE ?";
            try (PreparedStatement statement3 = connection.prepareStatement(query);){
                statement3.setString(1, this.getMigrationsTableName());
                migrationsExist = statement3.executeQuery().next();
            }
            if (!migrationsExist) {
                String createTable = "CREATE TABLE " + this.getMigrationsTableName() + " (migration_version INT NOT NULL)";
                try (PreparedStatement statement4 = connection.prepareStatement(createTable);){
                    statement4.execute();
                }
                String insertRow = "INSERT INTO " + this.getMigrationsTableName() + " VALUES (?)";
                statement2 = connection.prepareStatement(insertRow);
                try {
                    statement2.setInt(1, -1);
                    statement2.execute();
                }
                finally {
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
            }
            String selectVersion = "SELECT migration_version FROM " + this.getMigrationsTableName();
            boolean badState = false;
            statement2 = connection.prepareStatement(selectVersion);
            try {
                ResultSet result = statement2.executeQuery();
                if (result.next()) {
                    currentMigration = result.getInt("migration_version");
                } else {
                    badState = true;
                }
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
            }
            if (badState) {
                RoseGardenUtils.getLogger().severe("Database migration table is missing the migration_version row! The database is currently in a bad state due to an unknown issue. Attempting to fix the migration column automatically... please contact the plugin developer for assistance if this does not work.");
                currentMigration = this.migrations.stream().mapToInt(DataMigration::getRevision).max().orElse(-1);
                String insertRow = "INSERT INTO " + this.getMigrationsTableName() + " VALUES (?)";
                statement = connection.prepareStatement(insertRow);
                try {
                    statement.setInt(1, currentMigration);
                    statement.execute();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            int finalCurrentMigration = currentMigration;
            List requiredMigrations = this.migrations.stream().filter(x -> x.getRevision() > finalCurrentMigration).sorted(Comparator.comparingInt(DataMigration::getRevision)).collect(Collectors.toList());
            if (requiredMigrations.isEmpty()) {
                return;
            }
            for (DataMigration dataMigration : requiredMigrations) {
                dataMigration.migrate(databaseConnector, connection, dataManager.getTablePrefix());
            }
            currentMigration = requiredMigrations.stream().mapToInt(DataMigration::getRevision).max().orElse(-1);
            String updateVersion = "UPDATE " + this.getMigrationsTableName() + " SET migration_version = ?";
            statement = connection.prepareStatement(updateVersion);
            try {
                statement.setInt(1, currentMigration);
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        });
    }

    @Override
    public void disable() {
    }

    private String getMigrationsTableName() {
        return this.rosePlugin.getManager(AbstractDataManager.class).getTablePrefix() + "migrations";
    }
}

