/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.manager;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.CommandMessages;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedFileConfiguration;
import me.refracdevelopment.simplegems.rosegarden.hook.PlaceholderAPIHook;
import me.refracdevelopment.simplegems.rosegarden.lib.jetbrains.annotations.NotNull;
import me.refracdevelopment.simplegems.rosegarden.locale.Locale;
import me.refracdevelopment.simplegems.rosegarden.locale.YamlFileLocale;
import me.refracdevelopment.simplegems.rosegarden.locale.provider.JarResourceLocaleProvider;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractConfigurationManager;
import me.refracdevelopment.simplegems.rosegarden.manager.Manager;
import me.refracdevelopment.simplegems.rosegarden.utils.HexUtils;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class AbstractLocaleManager
extends Manager {
    protected final File localeDirectory;
    protected Locale defaultLocale;
    protected Locale loadedLocale;

    public AbstractLocaleManager(RosePlugin rosePlugin) {
        super(rosePlugin);
        this.localeDirectory = new File(this.rosePlugin.getDataFolder(), "locale");
    }

    private void registerLocales(Collection<Locale> locales) {
        File[] files;
        StringPlaceholders.Builder placeholdersBuilder = StringPlaceholders.builder().delimiters("{{", "}}");
        this.injectPlaceholderConstants(placeholdersBuilder);
        StringPlaceholders placeholders = placeholdersBuilder.build();
        for (Locale locale : locales) {
            for (Map.Entry<String, Object> entry : locale.getLocaleValues().entrySet()) {
                if (entry.getValue() instanceof String) {
                    String value = (String)entry.getValue();
                    locale.getLocaleValues().put(entry.getKey(), placeholders.apply(value));
                    continue;
                }
                if (!(entry.getValue() instanceof List)) continue;
                List list = (List)entry.getValue();
                list.replaceAll(placeholders::apply);
                locale.getLocaleValues().put(entry.getKey(), list);
            }
        }
        this.defaultLocale = locales.stream().filter(x -> x.getLocaleName().equals("en_US")).findFirst().orElseThrow(() -> new IllegalStateException("No default 'locale/en_US.yml' locale found!"));
        if (!this.localeDirectory.exists()) {
            this.localeDirectory.mkdirs();
        }
        if ((files = this.localeDirectory.listFiles()) != null) {
            int migrated = 0;
            for (File file : files) {
                if (!file.getName().endsWith(".lang")) continue;
                File newFile = new File(this.localeDirectory, file.getName().replace(".lang", ".yml"));
                file.renameTo(newFile);
                ++migrated;
            }
            if (migrated > 0) {
                this.rosePlugin.getLogger().info("Migrated " + migrated + " locale files to the new .yml format");
            }
        }
        locales.forEach(this::registerLocale);
        String localeName = this.rosePlugin.getManager(AbstractConfigurationManager.class).getConfig().getString("locale");
        File localeFile = new File(this.localeDirectory, localeName + ".yml");
        if (localeFile.exists()) {
            this.loadedLocale = new YamlFileLocale(localeFile);
        } else {
            this.rosePlugin.getLogger().warning("Locale file '" + localeFile.getName() + "' not found, using default locale");
            this.loadedLocale = this.defaultLocale;
        }
    }

    private void registerLocale(Locale locale) {
        File file = new File(this.rosePlugin.getDataFolder() + "/locale", locale.getLocaleName() + ".yml");
        boolean newFile = false;
        if (!file.exists()) {
            try {
                file.createNewFile();
                newFile = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean changed = false;
        CommentedFileConfiguration configuration = CommentedFileConfiguration.loadConfiguration(file);
        Map<String, Object> defaultLocaleStrings = locale.getLocaleValues();
        for (String key : defaultLocaleStrings.keySet()) {
            Object value = defaultLocaleStrings.get(key);
            if (newFile && key.startsWith("_COMMENT_")) {
                configuration.addComments(((String)value).substring(1));
                changed = true;
                continue;
            }
            if (configuration.contains(key)) continue;
            configuration.set(key, value);
            changed = true;
        }
        if (changed) {
            configuration.save(file);
        }
    }

    @Override
    public void reload() {
        this.registerLocales(this.getJarResourceLocales());
    }

    @Override
    public void disable() {
    }

    protected Collection<Locale> getJarResourceLocales() {
        return new JarResourceLocaleProvider("locale").getLocales();
    }

    protected void injectPlaceholderConstants(StringPlaceholders.Builder builder) {
        builder.add("PLUGIN_NAME", this.rosePlugin.getName());
    }

    protected void handleMessage(CommandSender sender, String message) {
        sender.sendMessage(message);
    }

    @NotNull
    protected String getLocaleString(String key) {
        Object value = this.loadedLocale.getLocaleValues().get(key);
        if (!(value instanceof String)) {
            value = this.defaultLocale.getLocaleValues().get(key);
        }
        if (!(value instanceof String)) {
            throw new IllegalStateException("Missing locale string: " + key);
        }
        return (String)value;
    }

    public final String getLocaleMessage(String messageKey) {
        return this.getLocaleMessage(messageKey, StringPlaceholders.empty());
    }

    public final String getLocaleMessage(String messageKey, StringPlaceholders stringPlaceholders) {
        return HexUtils.colorify(stringPlaceholders.apply(this.getLocaleString(messageKey)));
    }

    public final String getCommandLocaleMessage(String messageKey) {
        return this.getCommandLocaleMessage(messageKey, StringPlaceholders.empty());
    }

    public final String getCommandLocaleMessage(String messageKey, StringPlaceholders stringPlaceholders) {
        String message;
        block2: {
            try {
                message = this.getLocaleMessage(messageKey, stringPlaceholders);
            }
            catch (IllegalStateException e) {
                message = CommandMessages.DEFAULT_MESSAGES.get(messageKey);
                if (message != null) break block2;
                throw new IllegalStateException("Missing command locale string: " + messageKey, e);
            }
        }
        return HexUtils.colorify(stringPlaceholders.apply(message));
    }

    public final void sendMessage(CommandSender sender, String messageKey, StringPlaceholders stringPlaceholders) {
        String prefix = this.getLocaleMessage("prefix");
        String message = this.getLocaleMessage(messageKey, stringPlaceholders);
        if (message.isEmpty()) {
            return;
        }
        this.sendParsedMessage(sender, prefix + message);
    }

    public final void sendMessage(CommandSender sender, String messageKey) {
        this.sendMessage(sender, messageKey, StringPlaceholders.empty());
    }

    public final void sendCommandMessage(CommandSender sender, String messageKey, StringPlaceholders stringPlaceholders) {
        String prefix = this.getLocaleMessage("prefix");
        String message = this.getCommandLocaleMessage(messageKey, stringPlaceholders);
        if (message.isEmpty()) {
            return;
        }
        this.sendParsedMessage(sender, prefix + message);
    }

    public final void sendCommandMessage(CommandSender sender, String messageKey) {
        this.sendCommandMessage(sender, messageKey, StringPlaceholders.empty());
    }

    public final void sendSimpleMessage(CommandSender sender, String messageKey, StringPlaceholders stringPlaceholders) {
        this.sendParsedMessage(sender, this.getLocaleMessage(messageKey, stringPlaceholders));
    }

    public final void sendSimpleMessage(CommandSender sender, String messageKey) {
        this.sendSimpleMessage(sender, messageKey, StringPlaceholders.empty());
    }

    public final void sendSimpleCommandMessage(CommandSender sender, String messageKey, StringPlaceholders stringPlaceholders) {
        this.sendParsedMessage(sender, this.getCommandLocaleMessage(messageKey, stringPlaceholders));
    }

    public final void sendSimpleCommandMessage(CommandSender sender, String messageKey) {
        this.sendSimpleCommandMessage(sender, messageKey, StringPlaceholders.empty());
    }

    public final void sendCustomMessage(CommandSender sender, String message) {
        this.sendParsedMessage(sender, message);
    }

    protected final String parsePlaceholders(CommandSender sender, String message) {
        if (sender instanceof Player) {
            return PlaceholderAPIHook.applyPlaceholders((OfflinePlayer)((Player)sender), message);
        }
        return message;
    }

    protected final void sendParsedMessage(CommandSender sender, String message) {
        if (message.isEmpty()) {
            return;
        }
        String parsedMessage = HexUtils.colorify(this.parsePlaceholders(sender, message));
        this.handleMessage(sender, parsedMessage);
    }
}

