/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.manager;

import java.util.List;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedFileConfiguration;
import me.refracdevelopment.simplegems.rosegarden.database.DataMigration;
import me.refracdevelopment.simplegems.rosegarden.database.DatabaseConnector;
import me.refracdevelopment.simplegems.rosegarden.database.MySQLConnector;
import me.refracdevelopment.simplegems.rosegarden.database.SQLiteConnector;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractConfigurationManager;
import me.refracdevelopment.simplegems.rosegarden.manager.Manager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class AbstractDataManager
extends Manager {
    protected DatabaseConnector databaseConnector;

    public AbstractDataManager(RosePlugin rosePlugin) {
        super(rosePlugin);
    }

    @Override
    public void reload() {
        try {
            AbstractConfigurationManager configurationManager = this.rosePlugin.getManager(AbstractConfigurationManager.class);
            CommentedFileConfiguration roseSettings = configurationManager.getConfig();
            if (roseSettings.getBoolean("mysql-settings.enabled")) {
                String hostname = roseSettings.getString("mysql-settings.hostname");
                int port = roseSettings.getInt("mysql-settings.port");
                String database = roseSettings.getString("mysql-settings.database-name");
                String username = roseSettings.getString("mysql-settings.user-name");
                String password = roseSettings.getString("mysql-settings.user-password");
                boolean useSSL = roseSettings.getBoolean("mysql-settings.use-ssl");
                int poolSize = roseSettings.getInt("mysql-settings.connection-pool-size");
                this.databaseConnector = new MySQLConnector((Plugin)this.rosePlugin, hostname, port, database, username, password, useSSL, poolSize);
                this.rosePlugin.getLogger().info("Data handler connected using MySQL.");
            } else {
                this.databaseConnector = new SQLiteConnector((Plugin)this.rosePlugin);
                this.databaseConnector.cleanup();
                this.rosePlugin.getLogger().info("Data handler connected using SQLite.");
            }
        }
        catch (Exception ex) {
            this.rosePlugin.getLogger().severe("Fatal error trying to connect to database. Please make sure all your connection settings are correct and try again. Plugin has been disabled.");
            ex.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this.rosePlugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        if (this.databaseConnector == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long deadline = now + 5000L;
        Object object = this.databaseConnector.getLock();
        synchronized (object) {
            while (!this.databaseConnector.isFinished() && now < deadline) {
                try {
                    this.databaseConnector.getLock().wait(deadline - now);
                    now = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.databaseConnector.closeConnection();
    }

    public final boolean isConnected() {
        return this.databaseConnector != null;
    }

    public final DatabaseConnector getDatabaseConnector() {
        return this.databaseConnector;
    }

    public String getTablePrefix() {
        return this.rosePlugin.getDescription().getName().toLowerCase() + '_';
    }

    public abstract List<Class<? extends DataMigration>> getDataMigrations();
}

