/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.manager;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedFileConfiguration;
import me.refracdevelopment.simplegems.rosegarden.config.RoseSetting;
import me.refracdevelopment.simplegems.rosegarden.config.SingularRoseSetting;
import me.refracdevelopment.simplegems.rosegarden.manager.Manager;

public abstract class AbstractConfigurationManager
extends Manager {
    private final Class<? extends RoseSetting> settingEnum;
    private CommentedFileConfiguration configuration;
    private Map<String, RoseSetting> cachedValues;

    public AbstractConfigurationManager(RosePlugin rosePlugin, Class<? extends RoseSetting> settingEnum) {
        super(rosePlugin);
        if (!settingEnum.isEnum()) {
            throw new IllegalArgumentException("settingEnum class must be of type Enum");
        }
        this.settingEnum = settingEnum;
    }

    @Override
    public void reload() {
        boolean appendHeader;
        File configFile = new File(this.rosePlugin.getDataFolder(), "config.yml");
        boolean changed = appendHeader = !configFile.exists();
        this.configuration = CommentedFileConfiguration.loadConfiguration(configFile);
        if (appendHeader) {
            this.configuration.addComments(this.getHeader());
        }
        for (RoseSetting setting : this.getSettings().values()) {
            setting.reset();
            changed |= setting.setIfNotExists(this.configuration);
        }
        if (changed) {
            this.configuration.save(configFile);
        }
    }

    @Override
    public void disable() {
        for (RoseSetting setting : this.getSettings().values()) {
            setting.reset();
        }
    }

    protected abstract String[] getHeader();

    public CommentedFileConfiguration getConfig() {
        return this.configuration;
    }

    private Map<String, RoseSetting> getSettings() {
        if (this.cachedValues == null) {
            try {
                RoseSetting[] roseSettings = (RoseSetting[])this.settingEnum.getDeclaredMethod("values", new Class[0]).invoke(null, new Object[0]);
                this.cachedValues = new LinkedHashMap<String, RoseSetting>();
                for (RoseSetting roseSetting : roseSettings) {
                    this.cachedValues.put(roseSetting.getKey(), roseSetting);
                }
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace();
                this.cachedValues = Collections.emptyMap();
            }
            this.injectAdditionalSettings();
        }
        return this.cachedValues;
    }

    private void injectAdditionalSettings() {
        Map<String, RoseSetting> values = this.cachedValues;
        this.cachedValues = new LinkedHashMap<String, RoseSetting>();
        if (this.rosePlugin.hasLocaleManager()) {
            this.cachedValues.put("locale", new SingularRoseSetting(this.rosePlugin, "locale", "en_US", "The locale to use in the /locale folder"));
        }
        this.cachedValues.putAll(values);
        if (this.rosePlugin.hasDataManager()) {
            Arrays.asList(new SingularRoseSetting(this.rosePlugin, "mysql-settings", null, "Settings for if you want to use MySQL for data management"), new SingularRoseSetting(this.rosePlugin, "mysql-settings.enabled", false, "Enable MySQL", "If false, SQLite will be used instead"), new SingularRoseSetting(this.rosePlugin, "mysql-settings.hostname", "", "MySQL Database Hostname"), new SingularRoseSetting(this.rosePlugin, "mysql-settings.port", 3306, "MySQL Database Port"), new SingularRoseSetting(this.rosePlugin, "mysql-settings.database-name", "", "MySQL Database Name"), new SingularRoseSetting(this.rosePlugin, "mysql-settings.user-name", "", "MySQL Database User Name"), new SingularRoseSetting(this.rosePlugin, "mysql-settings.user-password", "", "MySQL Database User Password"), new SingularRoseSetting(this.rosePlugin, "mysql-settings.use-ssl", false, "If the database connection should use SSL", "You should enable this if your database supports SSL"), new SingularRoseSetting(this.rosePlugin, "mysql-settings.connection-pool-size", 3, "The number of connections to make to the database")).forEach(x -> this.cachedValues.put(x.getKey(), (RoseSetting)x));
        }
    }
}

