/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.argument.EnumArgumentHandler;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentHandler;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandWrapper;
import me.refracdevelopment.simplegems.rosegarden.manager.Manager;
import me.refracdevelopment.simplegems.rosegarden.utils.ClassUtils;
import me.refracdevelopment.simplegems.rosegarden.utils.RoseGardenUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class AbstractCommandManager
extends Manager {
    private static final String ARGUMENT_PACKAGE = "me.refracdevelopment.simplegems.rosegarden.command.argument";
    private final Map<Class<? extends RoseCommandArgumentHandler>, RoseCommandArgumentHandler<?>> argumentHandlers = new HashMap();
    private List<RoseCommandWrapper> commandWrappers;

    public AbstractCommandManager(RosePlugin rosePlugin) {
        super(rosePlugin);
    }

    @Override
    public void reload() {
        if (this.commandWrappers == null) {
            this.commandWrappers = new ArrayList<RoseCommandWrapper>();
            for (Class<? extends RoseCommandWrapper> commandWrapperClass : this.getRootCommands()) {
                try {
                    Constructor<? extends RoseCommandWrapper> constructor = commandWrapperClass.getConstructor(RosePlugin.class);
                    RoseCommandWrapper commandWrapper = constructor.newInstance(new Object[]{this.rosePlugin});
                    this.commandWrappers.add(commandWrapper);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
            }
        }
        try {
            ArrayList<Class<RoseCommandArgumentHandler>> argumentHandlerClasses = new ArrayList<Class<RoseCommandArgumentHandler>>(ClassUtils.getClassesOf(this.rosePlugin, ARGUMENT_PACKAGE, RoseCommandArgumentHandler.class));
            this.getArgumentHandlerPackages().stream().map(x -> ClassUtils.getClassesOf(this.rosePlugin, x, RoseCommandArgumentHandler.class)).forEach(argumentHandlerClasses::addAll);
            for (Class clazz : argumentHandlerClasses) {
                if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
                RoseCommandArgumentHandler argumentHandler = (RoseCommandArgumentHandler)clazz.getConstructor(RosePlugin.class).newInstance(new Object[]{this.rosePlugin});
                this.argumentHandlers.put(clazz, argumentHandler);
            }
        }
        catch (Exception e) {
            this.rosePlugin.getLogger().severe("Fatal error initializing command argument handlers");
            e.printStackTrace();
        }
        this.commandWrappers.forEach(RoseCommandWrapper::register);
        Bukkit.getOnlinePlayers().forEach(Player::updateCommands);
    }

    @Override
    public void disable() {
        this.argumentHandlers.clear();
        this.commandWrappers.forEach(RoseCommandWrapper::unregister);
        Bukkit.getOnlinePlayers().forEach(Player::updateCommands);
    }

    public RoseCommandArgumentHandler<?> resolveArgumentHandler(Class<?> handledParameterClass) {
        if (handledParameterClass.isPrimitive()) {
            handledParameterClass = RoseGardenUtils.getPrimitiveAsWrapper(handledParameterClass);
        }
        Class<?> finalHandledParameterClass = handledParameterClass;
        Optional<RoseCommandArgumentHandler> optionalArgumentHandler = this.argumentHandlers.values().stream().filter(x -> x.getHandledType() != null && x.getHandledType() == finalHandledParameterClass).findFirst();
        if (optionalArgumentHandler.isPresent()) {
            return optionalArgumentHandler.get();
        }
        if (Enum.class.isAssignableFrom(handledParameterClass)) {
            return this.argumentHandlers.get(EnumArgumentHandler.class);
        }
        throw new IllegalStateException("Tried to resolve a RoseCommandArgumentHandler for an unhandled type");
    }

    public abstract List<Class<? extends RoseCommandWrapper>> getRootCommands();

    public abstract List<String> getArgumentHandlerPackages();
}

