/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.locale.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.refracdevelopment.simplegems.rosegarden.locale.Locale;
import me.refracdevelopment.simplegems.rosegarden.locale.YamlFileLocale;
import me.refracdevelopment.simplegems.rosegarden.locale.provider.LocaleProvider;

public class JarResourceLocaleProvider
implements LocaleProvider {
    private final String resourcePath;

    public JarResourceLocaleProvider(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public Collection<Locale> getLocales() {
        try {
            ArrayList<Locale> locales = new ArrayList<Locale>();
            URL url = JarResourceLocaleProvider.class.getClassLoader().getResource(this.resourcePath);
            if (url == null) {
                throw new IllegalArgumentException("JarResourceLocaleProvider could not find resource path: " + this.resourcePath);
            }
            URLConnection connection = url.openConnection();
            if (!(connection instanceof JarURLConnection)) {
                throw new IllegalArgumentException("JarResourceLocaleProvider can only handle jar URLs: " + url);
            }
            JarURLConnection jarConnection = (JarURLConnection)connection;
            JarFile jarFile = jarConnection.getJarFile();
            String prefix = jarConnection.getEntryName() + "/";
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(prefix) || entry.isDirectory() || !name.endsWith(".yml")) continue;
                String localeName = name.substring(prefix.length(), name.length() - 4);
                InputStream inputStream = jarFile.getInputStream(entry);
                try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                    YamlFileLocale locale = new YamlFileLocale(localeName, inputStreamReader);
                    locales.add(locale);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            return locales;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("JarResourceLocaleProvider could not load locales from resource path: " + this.resourcePath, e);
        }
    }
}

