/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import me.refracdevelopment.simplegems.rosegarden.database.DatabaseConnector;
import me.refracdevelopment.simplegems.rosegarden.lib.hikaricp.HikariConfig;
import me.refracdevelopment.simplegems.rosegarden.lib.hikaricp.HikariDataSource;
import org.bukkit.plugin.Plugin;

public class MySQLConnector
implements DatabaseConnector {
    private final Plugin plugin;
    private HikariDataSource hikari;
    private final AtomicInteger openConnections;
    private final Object lock;

    public MySQLConnector(Plugin plugin, String hostname, int port, String database, String username, String password, boolean useSSL, int poolSize) {
        this.plugin = plugin;
        this.openConnections = new AtomicInteger();
        this.lock = new Object();
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + hostname + ":" + port + "/" + database + "?useSSL=" + useSSL + "&allowPublicKeyRetrieval=true&serverTimezone=UTC&useUnicode=true&characterEncoding=UTF-8");
        config.setUsername(username);
        config.setPassword(password);
        config.setMaximumPoolSize(poolSize);
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e1) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            this.hikari = new HikariDataSource(config);
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Failed to connect to the MySQL server. Are your credentials correct?");
            ex.printStackTrace();
        }
    }

    @Override
    public void closeConnection() {
        this.hikari.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(DatabaseConnector.ConnectionCallback callback) {
        this.openConnections.incrementAndGet();
        try (Connection connection = this.hikari.getConnection();){
            callback.accept(connection);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("An error occurred executing a MySQL query: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            int open = this.openConnections.decrementAndGet();
            Object object = this.lock;
            synchronized (object) {
                if (open == 0) {
                    this.lock.notify();
                }
            }
        }
    }

    @Override
    public void connect(DatabaseConnector.ConnectionCallback callback, boolean useTransaction) {
        this.connect(callback);
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    @Override
    public boolean isFinished() {
        return this.openConnections.get() == 0;
    }

    @Override
    public void cleanup() {
    }
}

