/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedConfigurationSection;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedFileConfiguration;
import me.refracdevelopment.simplegems.rosegarden.config.RoseSettingSection;
import me.refracdevelopment.simplegems.rosegarden.config.RoseSettingValue;
import me.refracdevelopment.simplegems.rosegarden.utils.RoseGardenUtils;

public interface RoseSetting {
    public String getKey();

    public Object getDefaultValue();

    public String[] getComments();

    public Object getCachedValue();

    public CommentedFileConfiguration getBaseConfig();

    public void setCachedValue(Object var1);

    default public boolean getBoolean() {
        this.loadValue();
        return (Boolean)this.getCachedValue();
    }

    default public int getInt() {
        this.loadValue();
        return (int)RoseGardenUtils.getNumber(this.getCachedValue());
    }

    default public long getLong() {
        this.loadValue();
        return (long)RoseGardenUtils.getNumber(this.getCachedValue());
    }

    default public double getDouble() {
        this.loadValue();
        return RoseGardenUtils.getNumber(this.getCachedValue());
    }

    default public float getFloat() {
        this.loadValue();
        return (float)RoseGardenUtils.getNumber(this.getCachedValue());
    }

    default public String getString() {
        this.loadValue();
        return String.valueOf(this.getCachedValue());
    }

    default public List<String> getStringList() {
        this.loadValue();
        return (List)this.getCachedValue();
    }

    default public CommentedConfigurationSection getSection() {
        this.loadValue();
        return (CommentedConfigurationSection)this.getCachedValue();
    }

    default public void loadValue() {
        if (this.getCachedValue() != null) {
            return;
        }
        String key = this.getKey();
        CommentedFileConfiguration config = this.getBaseConfig();
        if (config.isConfigurationSection(key)) {
            this.setCachedValue(config.getConfigurationSection(key));
        } else {
            this.setCachedValue(config.get(key));
        }
    }

    default public void reset() {
        this.setCachedValue(null);
    }

    default public boolean setIfNotExists(CommentedFileConfiguration fileConfiguration) {
        this.loadValue();
        String key = this.getKey();
        Object defaultValue = this.getDefaultValue();
        if (this.getCachedValue() == null) {
            ArrayList<String> comments = new ArrayList<String>(Arrays.asList(this.getComments()));
            if (!(defaultValue instanceof RoseSettingValue || defaultValue instanceof RoseSettingSection || defaultValue instanceof List || defaultValue == null)) {
                String defaultComment = "Default: ";
                defaultComment = defaultValue instanceof String ? (RoseGardenUtils.containsConfigSpecialCharacters((String)defaultValue) ? defaultComment + "'" + defaultValue + "'" : defaultComment + defaultValue) : defaultComment + defaultValue;
                comments.add(defaultComment);
            }
            String[] commentsArray = comments.toArray(new String[0]);
            if (defaultValue != null) {
                RoseSettingValue value = new RoseSettingValue(key, defaultValue, commentsArray);
                RoseGardenUtils.recursivelyWriteRoseSettingValues(fileConfiguration, value);
            } else {
                fileConfiguration.addPathedComments(key, commentsArray);
            }
            return true;
        }
        return false;
    }
}

