/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.config;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CommentedConfigurationSection
implements ConfigurationSection {
    private final AtomicInteger commentsCounter;
    protected ConfigurationSection config;

    public CommentedConfigurationSection(ConfigurationSection configuration, AtomicInteger commentsCounter) {
        this.config = configuration;
        this.commentsCounter = commentsCounter;
    }

    public void set(String path, Object value, String ... comments) {
        this.addPathedComments(path, comments);
        this.set(path, value);
    }

    public void addComments(String ... comments) {
        for (String comment : comments) {
            this.set("_COMMENT_" + this.commentsCounter.getAndIncrement(), " " + comment);
        }
    }

    public void addPathedComments(String path, String ... comments) {
        if (!this.contains(path)) {
            int subpathIndex = path.lastIndexOf(46);
            String subpath = subpathIndex == -1 ? "" : path.substring(0, subpathIndex) + '.';
            for (String comment : comments) {
                this.set(subpath + "_COMMENT_" + this.commentsCounter.getAndIncrement(), " " + comment);
            }
        }
    }

    public Boolean getDefaultedBoolean(String path) {
        String stringValue;
        if (this.isBoolean(path)) {
            return this.getBoolean(path);
        }
        if (this.isString(path) && (stringValue = this.getString(path)) != null && stringValue.equalsIgnoreCase("default")) {
            return null;
        }
        return null;
    }

    public Boolean getDefaultedBoolean(String path, Boolean def) {
        String stringValue;
        Object value = this.get(path);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String && (stringValue = (String)value).equalsIgnoreCase("default")) {
            return null;
        }
        if (value == null) {
            return def;
        }
        return null;
    }

    public Set<String> getKeys(boolean b) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(this.config.getKeys(b));
        keys.removeIf(x -> x.startsWith("_COMMENT_"));
        return keys;
    }

    public Map<String, Object> getValues(boolean b) {
        return this.config.getValues(b);
    }

    public boolean contains(String s) {
        return this.config.contains(s);
    }

    public boolean contains(String s, boolean b) {
        return this.config.contains(s, b);
    }

    public boolean isSet(String s) {
        return this.config.isSet(s);
    }

    public String getCurrentPath() {
        return this.config.getCurrentPath();
    }

    public String getName() {
        return this.config.getName();
    }

    public Configuration getRoot() {
        return this.config.getRoot();
    }

    public ConfigurationSection getParent() {
        return this.config.getParent();
    }

    public Object get(String s) {
        return this.config.get(s);
    }

    public Object get(String s, Object o) {
        return this.config.get(s, o);
    }

    public void set(String s, Object o) {
        this.config.set(s, o);
    }

    public CommentedConfigurationSection createSection(String s) {
        return new CommentedConfigurationSection(this.config.createSection(s), this.commentsCounter);
    }

    public CommentedConfigurationSection createSection(String s, Map<?, ?> map) {
        return new CommentedConfigurationSection(this.config.createSection(s, map), this.commentsCounter);
    }

    public String getString(String s) {
        return this.config.getString(s);
    }

    public String getString(String s, String s1) {
        return this.config.getString(s, s1);
    }

    public boolean isString(String s) {
        return this.config.isString(s);
    }

    public int getInt(String s) {
        return this.config.getInt(s);
    }

    public int getInt(String s, int i) {
        return this.config.getInt(s, i);
    }

    public boolean isInt(String s) {
        return this.config.isInt(s);
    }

    public boolean getBoolean(String s) {
        return this.config.getBoolean(s);
    }

    public boolean getBoolean(String s, boolean b) {
        return this.config.getBoolean(s, b);
    }

    public boolean isBoolean(String s) {
        return this.config.isBoolean(s);
    }

    public double getDouble(String s) {
        return this.config.getDouble(s);
    }

    public double getDouble(String s, double v) {
        return this.config.getDouble(s, v);
    }

    public boolean isDouble(String s) {
        return this.config.isDouble(s);
    }

    public long getLong(String s) {
        return this.config.getLong(s);
    }

    public long getLong(String s, long l) {
        return this.config.getLong(s, l);
    }

    public boolean isLong(String s) {
        return this.config.isLong(s);
    }

    public List<?> getList(String s) {
        return this.config.getList(s);
    }

    public List<?> getList(String s, List<?> list) {
        return this.config.getList(s, list);
    }

    public boolean isList(String s) {
        return this.config.isList(s);
    }

    public List<String> getStringList(String s) {
        return this.config.getStringList(s);
    }

    public List<Integer> getIntegerList(String s) {
        return this.config.getIntegerList(s);
    }

    public List<Boolean> getBooleanList(String s) {
        return this.config.getBooleanList(s);
    }

    public List<Double> getDoubleList(String s) {
        return this.config.getDoubleList(s);
    }

    public List<Float> getFloatList(String s) {
        return this.config.getFloatList(s);
    }

    public List<Long> getLongList(String s) {
        return this.config.getLongList(s);
    }

    public List<Byte> getByteList(String s) {
        return this.config.getByteList(s);
    }

    public List<Character> getCharacterList(String s) {
        return this.config.getCharacterList(s);
    }

    public List<Short> getShortList(String s) {
        return this.config.getShortList(s);
    }

    public List<Map<?, ?>> getMapList(String s) {
        return this.config.getMapList(s);
    }

    public <T> T getObject(String s, Class<T> aClass) {
        return (T)this.config.getObject(s, aClass);
    }

    public <T> T getObject(String s, Class<T> aClass, T t) {
        return (T)this.config.getObject(s, aClass, t);
    }

    public <T extends ConfigurationSerializable> T getSerializable(String s, Class<T> aClass) {
        return (T)this.config.getSerializable(s, aClass);
    }

    public <T extends ConfigurationSerializable> T getSerializable(String s, Class<T> aClass, T t) {
        return (T)this.config.getSerializable(s, aClass, t);
    }

    public Vector getVector(String s) {
        return this.config.getVector(s);
    }

    public Vector getVector(String s, Vector vector) {
        return this.config.getVector(s, vector);
    }

    public boolean isVector(String s) {
        return this.config.isVector(s);
    }

    public OfflinePlayer getOfflinePlayer(String s) {
        return this.config.getOfflinePlayer(s);
    }

    public OfflinePlayer getOfflinePlayer(String s, OfflinePlayer offlinePlayer) {
        return this.config.getOfflinePlayer(s, offlinePlayer);
    }

    public boolean isOfflinePlayer(String s) {
        return this.config.isOfflinePlayer(s);
    }

    public ItemStack getItemStack(String s) {
        return this.config.getItemStack(s);
    }

    public ItemStack getItemStack(String s, ItemStack itemStack) {
        return this.config.getItemStack(s, itemStack);
    }

    public boolean isItemStack(String s) {
        return this.config.isItemStack(s);
    }

    public Color getColor(String s) {
        return this.config.getColor(s);
    }

    public Color getColor(String s, Color color) {
        return this.config.getColor(s, color);
    }

    public boolean isColor(String s) {
        return this.config.isColor(s);
    }

    public Location getLocation(String path) {
        return this.getSerializable(path, Location.class);
    }

    public Location getLocation(String path, Location def) {
        return this.getSerializable(path, Location.class, def);
    }

    public boolean isLocation(String path) {
        return this.getSerializable(path, Location.class) != null;
    }

    public CommentedConfigurationSection getConfigurationSection(String s) {
        ConfigurationSection section = this.config.getConfigurationSection(s);
        if (section == null) {
            return null;
        }
        return new CommentedConfigurationSection(section, this.commentsCounter);
    }

    public boolean isConfigurationSection(String s) {
        return this.config.isConfigurationSection(s);
    }

    public CommentedConfigurationSection getDefaultSection() {
        return new CommentedConfigurationSection(this.config.getDefaultSection(), this.commentsCounter);
    }

    public void addDefault(String s, Object o) {
        this.config.addDefault(s, o);
    }

    public List<String> getComments(String path) {
        throw new IllegalStateException("CommentedConfigurationSection does not support Spigot-API comment methods.");
    }

    public List<String> getInlineComments(String path) {
        throw new IllegalStateException("CommentedConfigurationSection does not support Spigot-API comment methods.");
    }

    public void setComments(String path, List<String> comments) {
        throw new IllegalStateException("CommentedConfigurationSection does not support Spigot-API comment methods.");
    }

    public void setInlineComments(String path, List<String> comments) {
        throw new IllegalStateException("CommentedConfigurationSection does not support Spigot-API comment methods.");
    }
}

