/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.command.framework;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.command.BaseCommand;
import me.refracdevelopment.simplegems.rosegarden.command.command.HelpCommand;
import me.refracdevelopment.simplegems.rosegarden.command.command.ReloadCommand;
import me.refracdevelopment.simplegems.rosegarden.command.framework.ArgumentParser;
import me.refracdevelopment.simplegems.rosegarden.command.framework.CommandContext;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommand;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentHandler;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentInfo;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseSubCommand;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedConfigurationSection;
import me.refracdevelopment.simplegems.rosegarden.config.CommentedFileConfiguration;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractCommandManager;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractLocaleManager;
import me.refracdevelopment.simplegems.rosegarden.utils.ClassUtils;
import me.refracdevelopment.simplegems.rosegarden.utils.CommandMapUtils;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public abstract class RoseCommandWrapper
extends BukkitCommand {
    private String activeName;
    private List<String> activeAliases;
    protected final RosePlugin rosePlugin;
    protected final List<RoseCommand> commands;
    protected final Map<String, RoseCommand> commandLookupMap;
    protected final AbstractCommandManager commandManager;
    protected final AbstractLocaleManager localeManager;

    public RoseCommandWrapper(RosePlugin rosePlugin) {
        super("");
        this.rosePlugin = rosePlugin;
        this.commands = new ArrayList<RoseCommand>();
        this.commandLookupMap = new HashMap<String, RoseCommand>();
        this.commandManager = rosePlugin.getManager(AbstractCommandManager.class);
        this.localeManager = rosePlugin.getManager(AbstractLocaleManager.class);
    }

    public void register() {
        try {
            ArrayList<Class<ReloadCommand>> commandClasses = new ArrayList<Class<ReloadCommand>>();
            if (this.includeBaseCommand()) {
                commandClasses.add(BaseCommand.class);
            }
            if (this.includeHelpCommand()) {
                commandClasses.add(HelpCommand.class);
            }
            if (this.includeReloadCommand()) {
                commandClasses.add(ReloadCommand.class);
            }
            this.getCommandPackages().stream().map(x -> ClassUtils.getClassesOf(this.rosePlugin, x, RoseCommand.class)).forEach(commandClasses::addAll);
            for (Class clazz : commandClasses) {
                if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || RoseSubCommand.class.isAssignableFrom(clazz)) continue;
                RoseCommand command = (RoseCommand)clazz.getConstructor(RosePlugin.class, RoseCommandWrapper.class).newInstance(new Object[]{this.rosePlugin, this});
                this.commands.add(command);
            }
            File commandsDirectory = new File(this.rosePlugin.getDataFolder(), "commands");
            commandsDirectory.mkdirs();
            File file = new File(commandsDirectory, this.getDefaultName() + ".yml");
            boolean exists = file.exists();
            CommentedFileConfiguration commandConfig = CommentedFileConfiguration.loadConfiguration(file);
            boolean modified = false;
            if (!exists) {
                commandConfig.addComments("This file lets you change the name and aliases for the " + this.getDefaultName() + " command.", "If you edit the name/aliases at the top of this file, you will need to restart the server to see all the changes applied properly.");
                modified = true;
            }
            if (!commandConfig.contains("name")) {
                commandConfig.set("name", this.getDefaultName());
                modified = true;
            }
            if (!commandConfig.contains("aliases")) {
                commandConfig.set("aliases", new ArrayList<String>(this.getDefaultAliases()));
                modified = true;
            }
            if (!this.commands.isEmpty()) {
                CommentedConfigurationSection subcommandsSection = commandConfig.getConfigurationSection("subcommands");
                if (subcommandsSection == null) {
                    subcommandsSection = commandConfig.createSection("subcommands");
                    modified = true;
                }
                for (RoseCommand command : this.commands) {
                    if (command.getDefaultName().isEmpty()) {
                        command.setNameAndAliases("", Collections.emptyList());
                        this.commandLookupMap.put("", command);
                        continue;
                    }
                    ConfigurationSection commandSection = subcommandsSection.getConfigurationSection(command.getDefaultName());
                    if (commandSection == null) {
                        commandSection = subcommandsSection.createSection(command.getDefaultName());
                        modified = true;
                    }
                    if (!commandSection.contains("name")) {
                        commandSection.set("name", (Object)command.getDefaultName());
                        modified = true;
                    }
                    if (!commandSection.contains("aliases")) {
                        commandSection.set("aliases", new ArrayList<String>(command.getDefaultAliases()));
                        modified = true;
                    }
                    String name = commandSection.getString("name", command.getDefaultName());
                    List aliases = commandSection.getStringList("aliases");
                    command.setNameAndAliases(name, aliases);
                    this.commandLookupMap.put(name.toLowerCase(), command);
                    aliases.forEach(x -> this.commandLookupMap.put(x.toLowerCase(), command));
                }
            }
            if (modified) {
                commandConfig.save(file);
            }
            this.activeName = commandConfig.getString("name");
            this.activeAliases = commandConfig.getStringList("aliases");
            CommandMapUtils.registerCommand(this.rosePlugin.getName().toLowerCase(), (Command)this);
        }
        catch (Exception e) {
            this.rosePlugin.getLogger().severe("Fatal error initializing command argument handlers");
            e.printStackTrace();
        }
    }

    public void unregister() {
        this.commands.clear();
        this.commandLookupMap.clear();
        CommandMapUtils.unregisterCommand((Command)this);
    }

    public RoseCommand getCommand(String commandName) {
        return this.commandLookupMap.get(commandName);
    }

    public List<RoseCommand> getCommands() {
        return this.commandLookupMap.values().stream().distinct().filter(x -> !x.getDefaultName().isEmpty()).sorted(Comparator.comparing(RoseCommand::getName)).collect(Collectors.toList());
    }

    public RoseSubCommand getSubCommand(RoseCommand command, String commandName) {
        return command.getSubCommands().get(commandName.toLowerCase());
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        try {
            String[] cmdArgs;
            RoseCommand overrideCommand;
            BaseCommand baseCommand;
            String override;
            RoseCommand command = this.getCommand(args.length == 0 ? "" : args[0]);
            if (command == null) {
                this.localeManager.sendCommandMessage(sender, "unknown-command", StringPlaceholders.single("cmd", this.getName()));
                return true;
            }
            boolean isOverridden = false;
            if (command instanceof BaseCommand && (override = (baseCommand = (BaseCommand)command).getOverrideCommand()) != null && (overrideCommand = this.getCommand(override)) != null) {
                command = overrideCommand;
                isOverridden = true;
            }
            if (args.length > 0) {
                cmdArgs = new String[args.length - 1];
                System.arraycopy(args, 1, cmdArgs, 0, cmdArgs.length);
            } else {
                cmdArgs = new String[]{};
            }
            CommandContext context = new CommandContext(sender, cmdArgs);
            ArgumentParser argumentParser = new ArgumentParser(context, new LinkedList<String>(Arrays.asList(cmdArgs)));
            this.runCommand(sender, command, argumentParser, new ArrayList<Object>(), 0, isOverridden);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.localeManager.sendCommandMessage(sender, "unknown-command-error");
        }
        return true;
    }

    private void runCommand(CommandSender sender, RoseCommand command, ArgumentParser argumentParser, List<Object> parsedArgs, int commandLayer, boolean skipPermissionCheck) throws ReflectiveOperationException {
        if (!skipPermissionCheck && !command.canUse((Permissible)sender)) {
            this.localeManager.sendCommandMessage(sender, "no-permission");
            return;
        }
        if (command.isPlayerOnly() && !(sender instanceof Player)) {
            this.localeManager.sendCommandMessage(sender, "only-player");
            return;
        }
        for (RoseCommandArgumentInfo argumentInfo : command.getArgumentInfo()) {
            if (!argumentParser.hasNext()) {
                if (argumentInfo.isOptional()) break;
                if (command.hasSubCommand()) {
                    this.localeManager.sendCommandMessage(sender, "missing-arguments-extra", StringPlaceholders.single("amount", command.getNumRequiredArguments()));
                } else {
                    this.localeManager.sendCommandMessage(sender, "missing-arguments", StringPlaceholders.single("amount", parsedArgs.size() + command.getNumRequiredArguments() + commandLayer));
                }
                return;
            }
            if (argumentInfo.isSubCommand()) {
                RoseSubCommand subCommand = this.getSubCommand(command, argumentParser.next());
                if (subCommand == null) {
                    this.localeManager.sendCommandMessage(sender, "invalid-subcommand");
                    return;
                }
                this.runCommand(sender, subCommand, argumentParser, parsedArgs, commandLayer + 1, false);
                return;
            }
            try {
                Object parsedArgument = this.commandManager.resolveArgumentHandler(argumentInfo.getType()).handle(argumentInfo, argumentParser);
                if (parsedArgument == null) {
                    this.localeManager.sendCommandMessage(sender, "invalid-argument-null", StringPlaceholders.single("name", argumentInfo.toString()));
                    return;
                }
                parsedArgs.add(parsedArgument);
            }
            catch (RoseCommandArgumentHandler.HandledArgumentException e) {
                String message = this.localeManager.getCommandLocaleMessage(e.getMessage(), e.getPlaceholders());
                this.localeManager.sendCommandMessage(sender, "invalid-argument", StringPlaceholders.single("message", message));
                return;
            }
        }
        this.executeCommand(argumentParser.getContext(), command, parsedArgs);
    }

    private void executeCommand(CommandContext context, RoseCommand command, List<Object> parsedArgs) throws ReflectiveOperationException {
        Stream.Builder<CommandContext> argumentBuilder = Stream.builder().add(context);
        parsedArgs.forEach(argumentBuilder::add);
        for (int i = parsedArgs.size(); i < command.getNumParametersWithInjectible(); ++i) {
            argumentBuilder.add(null);
        }
        command.getExecuteMethod().invoke((Object)command, argumentBuilder.build().toArray());
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 0) {
            return new ArrayList<String>(this.commandLookupMap.keySet());
        }
        if (args.length <= 1) {
            return this.commandLookupMap.keySet().stream().filter(x -> StringUtil.startsWithIgnoreCase((String)x, (String)args[args.length - 1])).collect(Collectors.toList());
        }
        RoseCommand command = this.getCommand(args[0]);
        if (command == null) {
            return Collections.emptyList();
        }
        String[] cmdArgs = new String[args.length - 1];
        System.arraycopy(args, 1, cmdArgs, 0, cmdArgs.length);
        CommandContext context = new CommandContext(sender, cmdArgs);
        ArgumentParser argumentParser = new ArgumentParser(context, new LinkedList<String>(Arrays.asList(cmdArgs)));
        return this.tabCompleteCommand(sender, command, argumentParser);
    }

    private List<String> tabCompleteCommand(CommandSender sender, RoseCommand command, ArgumentParser argumentParser) {
        if (!command.canUse((Permissible)sender) || command.isPlayerOnly() && !(sender instanceof Player)) {
            return Collections.emptyList();
        }
        for (RoseCommandArgumentInfo argumentInfo : command.getArgumentInfo()) {
            if (argumentInfo.isSubCommand()) {
                if (!argumentParser.hasNext()) {
                    return new ArrayList<String>(command.getSubCommands().keySet());
                }
                String input = argumentParser.next();
                RoseSubCommand subCommand = this.getSubCommand(command, input);
                if (subCommand == null) {
                    return command.getSubCommands().keySet().stream().filter(x -> StringUtil.startsWithIgnoreCase((String)x, (String)input)).collect(Collectors.toList());
                }
                if (argumentParser.hasNext()) {
                    return this.tabCompleteCommand(sender, subCommand, argumentParser);
                }
                return Collections.emptyList();
            }
            List<String> suggestions = this.commandManager.resolveArgumentHandler(argumentInfo.getType()).suggest(argumentInfo, argumentParser);
            String input = argumentParser.previous();
            if (argumentParser.hasNext()) continue;
            return suggestions.stream().filter(x -> StringUtil.startsWithIgnoreCase((String)x, (String)input)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String getPermission() {
        return this.rosePlugin.getName().toLowerCase() + ".basecommand";
    }

    public String getName() {
        return this.activeName;
    }

    public List<String> getAliases() {
        return this.activeAliases;
    }

    public abstract String getDefaultName();

    public abstract List<String> getDefaultAliases();

    public abstract List<String> getCommandPackages();

    public abstract boolean includeBaseCommand();

    public abstract boolean includeHelpCommand();

    public abstract boolean includeReloadCommand();
}

