/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.command.framework;

import java.util.List;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.ArgumentParser;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentInfo;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;

public abstract class RoseCommandArgumentHandler<T> {
    protected RosePlugin rosePlugin;
    protected Class<T> handledType;

    public RoseCommandArgumentHandler(RosePlugin rosePlugin, Class<T> handledType) {
        this.rosePlugin = rosePlugin;
        this.handledType = handledType;
    }

    protected abstract T handleInternal(RoseCommandArgumentInfo var1, ArgumentParser var2) throws HandledArgumentException;

    protected abstract List<String> suggestInternal(RoseCommandArgumentInfo var1, ArgumentParser var2);

    public final T handle(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) throws HandledArgumentException {
        if (!argumentParser.hasNext()) {
            throw new HandledArgumentException("No more arguments are available, is there an error in the command syntax?");
        }
        this.preProcess(argumentInfo);
        return this.handleInternal(argumentInfo, argumentParser);
    }

    public final List<String> suggest(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) {
        this.preProcess(argumentInfo);
        return this.suggestInternal(argumentInfo, argumentParser);
    }

    public Class<T> getHandledType() {
        return this.handledType;
    }

    public void preProcess(RoseCommandArgumentInfo argumentInfo) {
    }

    public static class HandledArgumentException
    extends RuntimeException {
        private final StringPlaceholders placeholders;

        public HandledArgumentException(String message, StringPlaceholders placeholders) {
            super(message);
            this.placeholders = placeholders;
        }

        public HandledArgumentException(String message) {
            this(message, StringPlaceholders.empty());
        }

        public StringPlaceholders getPlaceholders() {
            return this.placeholders;
        }
    }
}

