/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.command.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.CommandContext;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentInfo;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandWrapper;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseSubCommand;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.Inject;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.Optional;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.RoseExecutable;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractCommandManager;
import me.refracdevelopment.simplegems.rosegarden.utils.RoseGardenUtils;
import org.bukkit.permissions.Permissible;

public abstract class RoseCommand
implements Comparable<RoseCommand> {
    protected final RosePlugin rosePlugin;
    protected final RoseCommandWrapper parent;
    private final Map<String, RoseSubCommand> subCommands;
    private String activeName;
    private List<String> activeAliases;

    public RoseCommand(RosePlugin rosePlugin, RoseCommandWrapper parent, Class<?> ... subCommandClasses) {
        this.rosePlugin = rosePlugin;
        this.parent = parent;
        this.subCommands = new HashMap<String, RoseSubCommand>();
        this.generateSubCommands(subCommandClasses);
        this.validateExecuteMethod();
    }

    protected void setNameAndAliases(String name, List<String> aliases) {
        this.activeName = name;
        this.activeAliases = aliases;
    }

    public final String getName() {
        return this.activeName;
    }

    public final List<String> getAliases() {
        return this.activeAliases;
    }

    protected abstract String getDefaultName();

    protected List<String> getDefaultAliases() {
        return Collections.emptyList();
    }

    public abstract String getDescriptionKey();

    public abstract String getRequiredPermission();

    public Method getExecuteMethod() {
        return Stream.of(this.getClass().getDeclaredMethods()).filter(m -> m.isAnnotationPresent(RoseExecutable.class)).findFirst().orElseThrow(IllegalStateException::new);
    }

    public List<RoseCommandArgumentInfo> getArgumentInfo() {
        ArrayList<RoseCommandArgumentInfo> argumentInfo = new ArrayList<RoseCommandArgumentInfo>();
        Parameter[] parameters = this.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            argumentInfo.add(new RoseCommandArgumentInfo(parameters[i], i));
        }
        return argumentInfo;
    }

    public Map<String, RoseSubCommand> getSubCommands() {
        return Collections.unmodifiableMap(this.subCommands);
    }

    public int getSubCommandArgumentIndex() {
        return this.getArgumentInfo().stream().filter(RoseCommandArgumentInfo::isSubCommand).map(RoseCommandArgumentInfo::getIndex).findFirst().orElse(-1);
    }

    public boolean hasSubCommand() {
        return this.getSubCommandArgumentIndex() != -1;
    }

    public String getArgumentsString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<RoseCommandArgumentInfo> iterator = this.getArgumentInfo().iterator();
        while (iterator.hasNext()) {
            RoseCommandArgumentInfo argument = iterator.next();
            stringBuilder.append(argument);
            if (argument.isSubCommand()) break;
            if (!iterator.hasNext()) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public int getNumParameters() {
        return this.getParameters().length - (!this.getExecuteMethod().getParameters()[0].isAnnotationPresent(Inject.class) ? 0 : 1);
    }

    public int getNumParametersWithInjectible() {
        return this.getParameters().length;
    }

    public int getNumOptionalParameters() {
        return Math.toIntExact(this.getArgumentInfo().stream().filter(RoseCommandArgumentInfo::isOptional).count());
    }

    public int getNumRequiredArguments() {
        return this.getNumParameters() - this.getNumOptionalParameters();
    }

    private Parameter[] getParameters() {
        return (Parameter[])Stream.of(this.getExecuteMethod().getParameters()).filter(x -> x.getType() != CommandContext.class).filter(x -> !x.isAnnotationPresent(Inject.class)).toArray(Parameter[]::new);
    }

    public boolean canUse(Permissible permissible) {
        return this.getRequiredPermission() == null || permissible.hasPermission(this.getRequiredPermission());
    }

    public boolean hasHelp() {
        return true;
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @Override
    public int compareTo(RoseCommand other) {
        return this.getDefaultName().compareTo(other.getDefaultName());
    }

    private void validateExecuteMethod() {
        try {
            this.getExecuteMethod();
        }
        catch (IllegalStateException e) {
            throw new InvalidRoseCommandArgumentsException("No method marked as RoseExecutable detected");
        }
        Parameter[] rawParameters = this.getExecuteMethod().getParameters();
        if (rawParameters.length == 0 || rawParameters[0].getType() != CommandContext.class) {
            throw new InvalidRoseCommandArgumentsException("First method parameter is not a CommandContext");
        }
        AbstractCommandManager commandManager = this.rosePlugin.getManager(AbstractCommandManager.class);
        boolean first = true;
        boolean optionalFound = false;
        boolean subCommandFound = false;
        for (Parameter parameter : rawParameters) {
            if (first) {
                first = false;
                continue;
            }
            if (parameter.getType() == CommandContext.class) {
                throw new InvalidRoseCommandArgumentsException("Only the first parameter may be a CommandContext");
            }
            if (subCommandFound) {
                throw new InvalidRoseCommandArgumentsException("Parameters after a RoseSubCommand are not allowed");
            }
            if (optionalFound && !parameter.isAnnotationPresent(Optional.class)) {
                throw new InvalidRoseCommandArgumentsException("Parameter '" + parameter.getType().getSimpleName() + " " + parameter.getName() + "' must be marked as Optional because a previous parameter was already marked as Optional");
            }
            if (parameter.getType() != RoseSubCommand.class) {
                try {
                    commandManager.resolveArgumentHandler(parameter.getType());
                }
                catch (IllegalStateException e) {
                    throw new InvalidRoseCommandArgumentsException("Parameter '" + parameter.getType().getSimpleName() + " " + parameter.getName() + "' is missing a RoseCommandArgumentHandler");
                }
            } else {
                subCommandFound = true;
            }
            if (!parameter.isAnnotationPresent(Optional.class)) continue;
            if (parameter.getType().isPrimitive()) {
                throw new InvalidRoseCommandArgumentsException("Parameter '" + parameter.getType().getSimpleName() + " " + parameter.getName() + "' is primitive but is marked as Optional. Change to a " + RoseGardenUtils.getPrimitiveAsWrapper(parameter.getType()) + " instead");
            }
            optionalFound = true;
        }
        if (subCommandFound && this.subCommands.isEmpty()) {
            throw new InvalidRoseCommandArgumentsException("No subcommands are registered but at least one is required");
        }
    }

    private void generateSubCommands(Class<?>[] subCommandClasses) {
        HashSet subClasses = new HashSet(Arrays.asList(subCommandClasses));
        subClasses.addAll(Arrays.asList(this.getClass().getDeclaredClasses()));
        for (Class clazz : subClasses) {
            RoseSubCommand subCommandInstance;
            if (!RoseSubCommand.class.isAssignableFrom(clazz)) continue;
            Class subCommandClass = clazz;
            try {
                Constructor pluginConstructor = subCommandClass.getConstructor(RosePlugin.class, RoseCommandWrapper.class);
                subCommandInstance = (RoseSubCommand)pluginConstructor.newInstance(new Object[]{this.rosePlugin, this.parent});
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Invalid RoseSubCommand constructor for [" + subCommandClass.getName() + "]. Requires a constructor that accepts a RosePlugin and a RoseCommandWrapper.");
            }
            this.subCommands.put(subCommandInstance.getDefaultName().toLowerCase(), subCommandInstance);
            List<String> aliases = subCommandInstance.getAliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                this.subCommands.put(alias.toLowerCase(), subCommandInstance);
            }
        }
    }

    public static class InvalidRoseCommandArgumentsException
    extends RuntimeException {
        public InvalidRoseCommandArgumentsException(String message) {
            super(message);
        }
    }
}

