/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.command.command;

import java.util.Collections;
import java.util.List;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.CommandContext;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommand;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandWrapper;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.RoseExecutable;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractLocaleManager;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;
import org.bukkit.permissions.Permissible;

public class HelpCommand
extends RoseCommand {
    public HelpCommand(RosePlugin rosePlugin, RoseCommandWrapper parent) {
        super(rosePlugin, parent, new Class[0]);
    }

    @RoseExecutable
    public void execute(CommandContext context) {
        AbstractLocaleManager localeManager = this.rosePlugin.getManager(AbstractLocaleManager.class);
        localeManager.sendCommandMessage(context.getSender(), "command-help-title");
        for (RoseCommand command : this.parent.getCommands()) {
            if (!command.hasHelp() || !command.canUse((Permissible)context.getSender())) continue;
            StringPlaceholders stringPlaceholders = StringPlaceholders.builder("cmd", this.parent.getName()).add("subcmd", command.getName().toLowerCase()).add("args", command.getArgumentsString()).add("desc", localeManager.getLocaleMessage(command.getDescriptionKey())).build();
            localeManager.sendSimpleCommandMessage(context.getSender(), "command-help-list-description" + (command.getNumParameters() == 0 ? "-no-args" : ""), stringPlaceholders);
        }
    }

    @Override
    public String getDefaultName() {
        return "help";
    }

    @Override
    public List<String> getDefaultAliases() {
        return Collections.emptyList();
    }

    @Override
    public String getDescriptionKey() {
        return "command-help-description";
    }

    @Override
    public String getRequiredPermission() {
        return null;
    }
}

