/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.command.argument;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.ArgumentParser;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentHandler;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentInfo;
import me.refracdevelopment.simplegems.rosegarden.command.framework.types.SelectorPlayer;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SelectorPlayerArgumentHandler
extends RoseCommandArgumentHandler<SelectorPlayer> {
    public SelectorPlayerArgumentHandler(RosePlugin rosePlugin) {
        super(rosePlugin, SelectorPlayer.class);
    }

    @Override
    protected SelectorPlayer handleInternal(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) {
        String input = argumentParser.next();
        if (input.startsWith("@")) {
            List entities;
            try {
                entities = Bukkit.selectEntities((CommandSender)argumentParser.getContext().getSender(), (String)input);
            }
            catch (Exception e) {
                throw new RoseCommandArgumentHandler.HandledArgumentException("argument-handler-player-selector-syntax");
            }
            if (entities.isEmpty()) {
                throw new RoseCommandArgumentHandler.HandledArgumentException("argument-handler-player-selector-none");
            }
            if (entities.size() > 1) {
                throw new RoseCommandArgumentHandler.HandledArgumentException("argument-handler-player-selector-multiple");
            }
            Entity selected = (Entity)entities.get(0);
            if (!(selected instanceof Player)) {
                throw new RoseCommandArgumentHandler.HandledArgumentException("argument-handler-player-selector-entity");
            }
            return new SelectorPlayer((Player)selected);
        }
        Player player = Bukkit.getPlayer((String)input);
        if (player == null) {
            throw new RoseCommandArgumentHandler.HandledArgumentException("argument-handler-player", StringPlaceholders.single("input", input));
        }
        return new SelectorPlayer(player);
    }

    @Override
    protected List<String> suggestInternal(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) {
        argumentParser.next();
        ArrayList<String> suggestions = new ArrayList<String>(Arrays.asList("@p", "@r"));
        suggestions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
        return suggestions;
    }
}

