/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.command.argument;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.ArgumentParser;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentHandler;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentInfo;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class OfflinePlayerArgumentHandler
extends RoseCommandArgumentHandler<OfflinePlayer> {
    private static Method getOfflinePlayerIfCachedMethod;

    public OfflinePlayerArgumentHandler(RosePlugin rosePlugin) {
        super(rosePlugin, OfflinePlayer.class);
    }

    @Override
    protected OfflinePlayer handleInternal(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) {
        String input = argumentParser.next();
        if (getOfflinePlayerIfCachedMethod != null) {
            try {
                return (OfflinePlayer)getOfflinePlayerIfCachedMethod.invoke(null, input);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Bukkit.getOfflinePlayer((String)input);
    }

    @Override
    protected List<String> suggestInternal(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) {
        argumentParser.next();
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
    }

    static {
        try {
            getOfflinePlayerIfCachedMethod = Bukkit.class.getDeclaredMethod("getOfflinePlayerIfCached", String.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

