/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.command.argument;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.ArgumentParser;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentHandler;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentInfo;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;

public class EnumArgumentHandler<T extends Enum<T>>
extends RoseCommandArgumentHandler<T> {
    public EnumArgumentHandler(RosePlugin rosePlugin) {
        super(rosePlugin, null);
    }

    @Override
    protected T handleInternal(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) {
        String input = argumentParser.next();
        Enum[] enumConstants = (Enum[])this.getHandledType().getEnumConstants();
        Optional<Enum> value = Stream.of(enumConstants).filter(x -> x.name().equalsIgnoreCase(input)).findFirst();
        if (!value.isPresent()) {
            StringPlaceholders placeholders = StringPlaceholders.builder("enum", this.handledType.getSimpleName()).add("input", input).add("types", Stream.of(enumConstants).map(x -> x.name().toLowerCase()).collect(Collectors.joining(", "))).build();
            String messageKey = enumConstants.length <= 10 ? "argument-handler-enum-list" : "argument-handler-enum";
            throw new RoseCommandArgumentHandler.HandledArgumentException(messageKey, placeholders);
        }
        return (T)value.get();
    }

    @Override
    protected List<String> suggestInternal(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) {
        argumentParser.next();
        return Stream.of((Enum[])this.getHandledType().getEnumConstants()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList());
    }

    @Override
    public void preProcess(RoseCommandArgumentInfo argumentInfo) {
        this.handledType = argumentInfo.getType();
    }
}

