/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.command.argument;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.ArgumentParser;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentHandler;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandArgumentInfo;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;

public abstract class AbstractColorArgumentHandler<T>
extends RoseCommandArgumentHandler<T> {
    private static final Map<String, org.bukkit.Color> COLOR_NAME_MAP = new HashMap<String, org.bukkit.Color>();

    public AbstractColorArgumentHandler(RosePlugin rosePlugin, Class<T> clazz) {
        super(rosePlugin, clazz);
    }

    protected abstract T rgbToColor(int var1, int var2, int var3);

    @Override
    protected final T handleInternal(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) {
        String input = argumentParser.next();
        if (input.startsWith("#")) {
            try {
                Color color = Color.decode(input);
                return this.rgbToColor(color.getRed(), color.getGreen(), color.getBlue());
            }
            catch (NumberFormatException e) {
                throw new RoseCommandArgumentHandler.HandledArgumentException("argument-handler-color-hex", StringPlaceholders.single("input", input));
            }
        }
        org.bukkit.Color namedColor = COLOR_NAME_MAP.get(input.toLowerCase());
        if (namedColor != null) {
            return this.rgbToColor(namedColor.getRed(), namedColor.getGreen(), namedColor.getBlue());
        }
        String input2 = argumentParser.next();
        String input3 = argumentParser.next();
        if (input2.isEmpty() && input3.isEmpty()) {
            throw new RoseCommandArgumentHandler.HandledArgumentException("argument-handler-color-hex", StringPlaceholders.single("input", input));
        }
        try {
            return this.rgbToColor(Integer.parseInt(input), Integer.parseInt(input2), Integer.parseInt(input3));
        }
        catch (NumberFormatException e) {
            throw new RoseCommandArgumentHandler.HandledArgumentException("argument-handler-color-rgb");
        }
    }

    @Override
    protected final List<String> suggestInternal(RoseCommandArgumentInfo argumentInfo, ArgumentParser argumentParser) {
        boolean isFirstNumber;
        String input = argumentParser.next();
        ArrayList<String> inputs = new ArrayList<String>(Arrays.asList("<#hexCode>", "<0-255> <0-255> <0-255>"));
        inputs.addAll(COLOR_NAME_MAP.keySet());
        if (input.isEmpty() && !argumentParser.hasNext() || input.startsWith("#")) {
            return inputs;
        }
        try {
            Integer.parseInt(input);
            isFirstNumber = true;
        }
        catch (Exception e) {
            isFirstNumber = false;
        }
        if (!isFirstNumber) {
            return inputs;
        }
        String input2 = argumentParser.next();
        String input3 = argumentParser.next();
        if (input2.isEmpty()) {
            return Collections.singletonList("<0-255> <0-255>");
        }
        if (input3.isEmpty()) {
            return Collections.singletonList("<0-255>");
        }
        return Collections.emptyList();
    }

    static {
        COLOR_NAME_MAP.put("red", org.bukkit.Color.fromRGB((int)255, (int)0, (int)0));
        COLOR_NAME_MAP.put("orange", org.bukkit.Color.fromRGB((int)255, (int)140, (int)0));
        COLOR_NAME_MAP.put("yellow", org.bukkit.Color.fromRGB((int)255, (int)255, (int)0));
        COLOR_NAME_MAP.put("lime", org.bukkit.Color.fromRGB((int)50, (int)205, (int)50));
        COLOR_NAME_MAP.put("green", org.bukkit.Color.fromRGB((int)0, (int)128, (int)0));
        COLOR_NAME_MAP.put("blue", org.bukkit.Color.fromRGB((int)0, (int)0, (int)255));
        COLOR_NAME_MAP.put("cyan", org.bukkit.Color.fromRGB((int)0, (int)139, (int)139));
        COLOR_NAME_MAP.put("light_blue", org.bukkit.Color.fromRGB((int)173, (int)216, (int)230));
        COLOR_NAME_MAP.put("purple", org.bukkit.Color.fromRGB((int)138, (int)43, (int)226));
        COLOR_NAME_MAP.put("magenta", org.bukkit.Color.fromRGB((int)202, (int)31, (int)123));
        COLOR_NAME_MAP.put("pink", org.bukkit.Color.fromRGB((int)255, (int)182, (int)193));
        COLOR_NAME_MAP.put("brown", org.bukkit.Color.fromRGB((int)139, (int)69, (int)19));
        COLOR_NAME_MAP.put("black", org.bukkit.Color.fromRGB((int)0, (int)0, (int)0));
        COLOR_NAME_MAP.put("gray", org.bukkit.Color.fromRGB((int)128, (int)128, (int)128));
        COLOR_NAME_MAP.put("light_gray", org.bukkit.Color.fromRGB((int)192, (int)192, (int)192));
        COLOR_NAME_MAP.put("white", org.bukkit.Color.fromRGB((int)255, (int)255, (int)255));
    }
}

