/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.objects.RosePluginData;
import me.refracdevelopment.simplegems.rosegarden.utils.HexUtils;
import me.refracdevelopment.simplegems.rosegarden.utils.RoseGardenUtils;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;

public class RwdCommand
extends BukkitCommand {
    private final RosePlugin rosePlugin;

    public RwdCommand(RosePlugin rosePlugin) {
        super("rwd", "Rosewood Development information command", "/rwd", Collections.emptyList());
        this.rosePlugin = rosePlugin;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        if (!sender.isOp()) {
            RoseGardenUtils.sendMessage(sender, "&cYou do not have permission to use this command.");
            return true;
        }
        List<RosePluginData> pluginData = this.rosePlugin.getLoadedRosePluginsData();
        ComponentBuilder builder = new ComponentBuilder();
        builder.append(TextComponent.fromLegacyText((String)HexUtils.colorify("&7[<g:#8A2387:#E94057:#F27121>RoseGarden&7] &ePlugins installed by <g:#8A2387:#E94057:#F27121>Rosewood Development&e. Hover over to view info: ")));
        boolean first = true;
        for (RosePluginData data : pluginData) {
            if (!first) {
                builder.append(TextComponent.fromLegacyText((String)HexUtils.colorify("&e, ")), ComponentBuilder.FormatRetention.NONE);
            }
            first = false;
            String updateVersion = data.getUpdateVersion();
            String website = data.getWebsite();
            ArrayList<Text> content = new ArrayList<Text>();
            content.add(new Text(TextComponent.fromLegacyText((String)HexUtils.colorify("&eVersion: &b" + data.getVersion()))));
            content.add(new Text(TextComponent.fromLegacyText((String)HexUtils.colorify("\n&eRoseGarden Version: &b" + data.getRoseGardenVersion()))));
            if (updateVersion != null) {
                content.add(new Text(TextComponent.fromLegacyText((String)HexUtils.colorify("\n&eAn update (&bv" + updateVersion + "&e) is available! Click to open the Spigot page."))));
            }
            TextComponent pluginName = new TextComponent(TextComponent.fromLegacyText((String)HexUtils.colorify("<g:#8A2387:#E94057:#F27121>" + data.getName())));
            pluginName.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Content[])content.toArray(new Text[0])));
            if (website != null) {
                pluginName.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, data.getWebsite()));
            }
            builder.append((BaseComponent)pluginName);
        }
        sender.spigot().sendMessage(builder.create());
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        return Collections.emptyList();
    }
}

