/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.rosegarden;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.refracdevelopment.simplegems.rosegarden.command.RwdCommand;
import me.refracdevelopment.simplegems.rosegarden.lib.bstats.bukkit.Metrics;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractCommandManager;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractConfigurationManager;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractDataManager;
import me.refracdevelopment.simplegems.rosegarden.manager.AbstractLocaleManager;
import me.refracdevelopment.simplegems.rosegarden.manager.DataMigrationManager;
import me.refracdevelopment.simplegems.rosegarden.manager.Manager;
import me.refracdevelopment.simplegems.rosegarden.manager.PluginUpdateManager;
import me.refracdevelopment.simplegems.rosegarden.objects.RosePluginData;
import me.refracdevelopment.simplegems.rosegarden.utils.CommandMapUtils;
import me.refracdevelopment.simplegems.rosegarden.utils.RoseGardenUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class RosePlugin
extends JavaPlugin {
    public static final String ROSEGARDEN_VERSION = "1.2.3";
    private final int spigotId;
    private final int bStatsId;
    private final Class<? extends AbstractConfigurationManager> configurationManagerClass;
    private final Class<? extends AbstractDataManager> dataManagerClass;
    private final Class<? extends AbstractLocaleManager> localeManagerClass;
    private final Class<? extends AbstractCommandManager> commandManagerClass;
    private final Map<Class<? extends Manager>, Manager> managers;

    public RosePlugin(int spigotId, int bStatsId, Class<? extends AbstractConfigurationManager> configurationManagerClass, Class<? extends AbstractDataManager> dataManagerClass, Class<? extends AbstractLocaleManager> localeManagerClass, Class<? extends AbstractCommandManager> commandManagerClass) {
        if (configurationManagerClass != null && Modifier.isAbstract(configurationManagerClass.getModifiers())) {
            throw new IllegalArgumentException("configurationManagerClass cannot be abstract");
        }
        if (dataManagerClass != null && Modifier.isAbstract(dataManagerClass.getModifiers())) {
            throw new IllegalArgumentException("dataManagerClass cannot be abstract");
        }
        if (localeManagerClass != null && Modifier.isAbstract(localeManagerClass.getModifiers())) {
            throw new IllegalArgumentException("localeManagerClass cannot be abstract");
        }
        if (commandManagerClass != null && Modifier.isAbstract(commandManagerClass.getModifiers())) {
            throw new IllegalArgumentException("commandManagerClass cannot be abstract");
        }
        this.spigotId = spigotId;
        this.bStatsId = bStatsId;
        this.configurationManagerClass = configurationManagerClass;
        this.dataManagerClass = dataManagerClass;
        this.localeManagerClass = localeManagerClass;
        this.commandManagerClass = commandManagerClass;
        this.managers = new LinkedHashMap<Class<? extends Manager>, Manager>();
    }

    public void onEnable() {
        this.getLogger().info("Initializing using RoseGarden v1.2.3");
        if (this.bStatsId != -1) {
            Metrics metrics = new Metrics(this, this.bStatsId);
            this.addCustomMetricsCharts(metrics);
        }
        if (!RoseGardenUtils.isRelocated()) {
            RoseGardenUtils.getLogger().severe("DEVELOPER ERROR!!! RoseGarden has not been relocated! Plugin has been forcefully disabled.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.reload();
        this.enable();
        this.injectService();
    }

    public void onDisable() {
        this.disable();
        this.disableManagers();
        this.managers.clear();
    }

    protected abstract void enable();

    protected abstract void disable();

    protected abstract List<Class<? extends Manager>> getManagerLoadPriority();

    protected void addCustomMetricsCharts(Metrics metrics) {
    }

    public void reload() {
        this.disableManagers();
        this.managers.values().forEach(Manager::reload);
        ArrayList<Class<Manager>> managerLoadPriority = new ArrayList<Class<Manager>>();
        if (this.hasConfigurationManager()) {
            managerLoadPriority.add(this.configurationManagerClass);
        }
        if (this.hasDataManager()) {
            managerLoadPriority.add(this.dataManagerClass);
            managerLoadPriority.add(DataMigrationManager.class);
        }
        if (this.hasLocaleManager()) {
            managerLoadPriority.add(this.localeManagerClass);
        }
        if (this.hasCommandManager()) {
            managerLoadPriority.add(this.commandManagerClass);
        }
        managerLoadPriority.addAll(this.getManagerLoadPriority());
        if (this.spigotId != -1) {
            managerLoadPriority.add(PluginUpdateManager.class);
        }
        managerLoadPriority.forEach(this::getManager);
    }

    private void disableManagers() {
        ArrayList<Manager> managers = new ArrayList<Manager>(this.managers.values());
        Collections.reverse(managers);
        managers.forEach(Manager::disable);
    }

    public <T extends Manager> T getManager(Class<T> managerClass) {
        if (this.managers.containsKey(managerClass)) {
            return (T)this.managers.get(managerClass);
        }
        if (this.hasConfigurationManager() && managerClass == AbstractConfigurationManager.class) {
            return (T)this.getManager(this.configurationManagerClass);
        }
        if (this.hasDataManager() && managerClass == AbstractDataManager.class) {
            return (T)this.getManager(this.dataManagerClass);
        }
        if (this.hasLocaleManager() && managerClass == AbstractLocaleManager.class) {
            return (T)this.getManager(this.localeManagerClass);
        }
        if (this.hasCommandManager() && managerClass == AbstractCommandManager.class) {
            return (T)this.getManager(this.commandManagerClass);
        }
        try {
            Manager manager = (Manager)managerClass.getConstructor(RosePlugin.class).newInstance(new Object[]{this});
            this.managers.put(managerClass, manager);
            manager.reload();
            return (T)manager;
        }
        catch (Exception ex) {
            throw new ManagerNotFoundException(managerClass, (Throwable)ex);
        }
    }

    public final int getSpigotId() {
        return this.spigotId;
    }

    public final int getBStatsId() {
        return this.bStatsId;
    }

    private void injectService() {
        boolean exists = !this.getLoadedRosePluginsData().isEmpty();
        Bukkit.getServicesManager().register(RosePlugin.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        if (exists) {
            return;
        }
        CommandMapUtils.registerCommand("rosegarden", (Command)new RwdCommand(this));
    }

    public final List<RosePluginData> getLoadedRosePluginsData() {
        ArrayList<RosePluginData> data = new ArrayList<RosePluginData>();
        ServicesManager servicesManager = Bukkit.getServicesManager();
        for (Class service : servicesManager.getKnownServices()) {
            try {
                String roseGardenVersion = (String)service.getField("ROSEGARDEN_VERSION").get(null);
                Method updateVersionMethod = service.getMethod("getUpdateVersion", new Class[0]);
                for (RegisteredServiceProvider provider : servicesManager.getRegistrations(service)) {
                    Plugin plugin = provider.getPlugin();
                    String pluginName = plugin.getName();
                    String pluginVersion = plugin.getDescription().getVersion();
                    String website = plugin.getDescription().getWebsite();
                    String updateVersion = (String)updateVersionMethod.invoke((Object)plugin, new Object[0]);
                    data.add(new RosePluginData(pluginName, pluginVersion, updateVersion, website, roseGardenVersion));
                }
            }
            catch (ClassCastException | ReflectiveOperationException exception) {
            }
        }
        return data;
    }

    public final File getRoseGardenDataFolder() {
        File configDir = new File(this.getDataFolder().getParentFile(), "RoseGarden");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        return configDir;
    }

    public final String getUpdateVersion() {
        return this.getManager(PluginUpdateManager.class).getUpdateVersion();
    }

    public final boolean hasConfigurationManager() {
        return this.configurationManagerClass != null;
    }

    public final boolean hasDataManager() {
        return this.dataManagerClass != null;
    }

    public final boolean hasLocaleManager() {
        return this.localeManagerClass != null;
    }

    public final boolean hasCommandManager() {
        return this.commandManagerClass != null;
    }

    private static class ManagerNotFoundException
    extends RuntimeException {
        public ManagerNotFoundException(Class<? extends Manager> managerClass, Throwable cause) {
            super("Failed to load " + managerClass.getSimpleName(), cause);
        }
    }
}

