/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.menu;

import ca.tweetzy.skulls.Skulls;
import ca.tweetzy.skulls.api.interfaces.Skull;
import java.util.List;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import me.refracdevelopment.simplegems.SimpleGems;
import me.refracdevelopment.simplegems.api.SimpleGemsAPI;
import me.refracdevelopment.simplegems.manager.LocaleManager;
import me.refracdevelopment.simplegems.utilities.ItemBuilder;
import me.refracdevelopment.simplegems.utilities.Methods;
import me.refracdevelopment.simplegems.utilities.Utilities;
import me.refracdevelopment.simplegems.utilities.chat.Color;
import me.refracdevelopment.simplegems.utilities.chat.Placeholders;
import me.refracdevelopment.simplegems.utilities.config.Menus;
import me.refracdevelopment.simplegems.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GemShopItem {
    private final XMaterial material;
    private final String skullOwner;
    private final String name;
    private final boolean skulls;
    private final boolean headDatabase;
    private final boolean messageEnabled;
    private final boolean broadcastMessage;
    private final boolean customData;
    private final boolean glow;
    private final boolean action;
    private final int data;
    private final int slot;
    private final int customModelData;
    private final List<String> lore;
    private final List<String> actions;
    private final List<String> commands;
    private final List<String> messages;
    private final long cost;

    public GemShopItem(String item) {
        this.material = Utilities.getMaterial(Menus.GEM_SHOP_ITEMS.getString(item + ".material"));
        this.headDatabase = Menus.GEM_SHOP_ITEMS.getBoolean(item + ".head-database") ? Menus.GEM_SHOP_ITEMS.getBoolean(item + ".head-database", false) : false;
        this.skulls = Menus.GEM_SHOP_ITEMS.getBoolean(item + ".skulls") ? Menus.GEM_SHOP_ITEMS.getBoolean(item + ".skulls", false) : false;
        this.customData = Menus.GEM_SHOP_ITEMS.getBoolean(item + ".customData") ? Menus.GEM_SHOP_ITEMS.getBoolean(item + ".customData", false) : false;
        this.skullOwner = Menus.GEM_SHOP_ITEMS.getString(item + ".skullOwner");
        this.glow = Menus.GEM_SHOP_ITEMS.getBoolean(item + ".glow") ? Menus.GEM_SHOP_ITEMS.getBoolean(item + ".glow") : false;
        this.data = Menus.GEM_SHOP_ITEMS.getInt(item + ".data");
        this.customModelData = Menus.GEM_SHOP_ITEMS.getInt(item + ".customModelData");
        this.name = Menus.GEM_SHOP_ITEMS.getString(item + ".name");
        this.lore = Menus.GEM_SHOP_ITEMS.getStringList(item + ".lore");
        this.action = Menus.GEM_SHOP_ITEMS.getBoolean(item + ".action.enabled") ? Menus.GEM_SHOP_ITEMS.getBoolean(item + ".action.enabled", false) : false;
        this.actions = Menus.GEM_SHOP_ITEMS.getStringList(item + ".action.actions");
        this.commands = Menus.GEM_SHOP_ITEMS.getStringList(item + ".commands");
        this.messageEnabled = Menus.GEM_SHOP_ITEMS.getBoolean(item + ".message.enabled");
        this.broadcastMessage = Menus.GEM_SHOP_ITEMS.getBoolean(item + ".message.broadcast");
        this.messages = Menus.GEM_SHOP_ITEMS.getStringList(item + ".message.text");
        this.cost = Menus.GEM_SHOP_ITEMS.getLong(item + ".cost");
        this.slot = Menus.GEM_SHOP_ITEMS.getInt(item + ".slot");
    }

    public void sendMessage(Player player) {
        if (!this.messageEnabled) {
            return;
        }
        LocaleManager locale = SimpleGems.getInstance().getManager(LocaleManager.class);
        if (this.broadcastMessage) {
            Bukkit.getOnlinePlayers().forEach(p -> this.messages.forEach(message -> locale.sendCustomMessage((CommandSender)p, Color.translate((CommandSender)player, message.replace("%item%", this.name).replace("%cost%", Methods.formatDec(this.cost))))));
        } else {
            this.messages.forEach(message -> locale.sendCustomMessage((CommandSender)player, Color.translate((CommandSender)player, message.replace("%item%", this.name).replace("%cost%", Methods.formatDec(this.cost)))));
        }
    }

    public void runCommands(Player player) {
        this.commands.forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)Placeholders.setPlaceholders((CommandSender)player, command.replace("%item%", this.name).replace("%cost%", String.valueOf(this.cost)))));
    }

    public void runActions(Player player) {
        this.actions.forEach(action -> SimpleGems.getInstance().getActionManager().execute(player, Placeholders.setPlaceholders((CommandSender)player, action.replace("%item%", this.name).replace("%cost%", String.valueOf(this.cost)))));
    }

    public ItemStack getItem(Player player) {
        if (this.headDatabase) {
            HeadDatabaseAPI api = new HeadDatabaseAPI();
            ItemBuilder item = new ItemBuilder(api.getItemHead(this.skullOwner));
            if (this.glow) {
                item.addEnchant(Enchantment.ARROW_DAMAGE, 1);
                ItemMeta itemMeta = item.toItemStack().getItemMeta();
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.toItemStack().setItemMeta(itemMeta);
            }
            item.setName(Color.translate((CommandSender)player, this.name));
            this.lore.forEach(s -> item.addLoreLine(Color.translate((CommandSender)player, s.replace("%item%", this.name).replace("%cost%", String.valueOf(this.cost)).replace("%price%", String.valueOf(this.cost)))));
            return item.toItemStack();
        }
        if (this.skulls) {
            Skull api = Skulls.getAPI().getSkull(Integer.parseInt(this.skullOwner));
            ItemBuilder item = new ItemBuilder(api.getItemStack());
            if (this.glow) {
                item.addEnchant(Enchantment.ARROW_DAMAGE, 1);
                ItemMeta itemMeta = item.toItemStack().getItemMeta();
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.toItemStack().setItemMeta(itemMeta);
            }
            item.setName(Color.translate((CommandSender)player, this.name));
            this.lore.forEach(s -> item.addLoreLine(Color.translate((CommandSender)player, s.replace("%item%", this.name).replace("%cost%", String.valueOf(this.cost)).replace("%price%", String.valueOf(this.cost)))));
            return item.toItemStack();
        }
        if (this.customData) {
            ItemBuilder item = new ItemBuilder(this.material.parseMaterial());
            if (this.glow) {
                item.addEnchant(Enchantment.ARROW_DAMAGE, 1);
                ItemMeta itemMeta = item.toItemStack().getItemMeta();
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.toItemStack().setItemMeta(itemMeta);
            }
            item.setCustomModelData(this.customModelData);
            item.setName(this.name);
            this.lore.forEach(s -> item.addLoreLine(Color.translate((CommandSender)player, s.replace("%item%", this.name).replace("%cost%", String.valueOf(this.cost)).replace("%price%", String.valueOf(this.cost)))));
            item.setDurability(this.data);
            item.setSkullOwner(this.skullOwner);
            return item.toItemStack();
        }
        ItemBuilder item = new ItemBuilder(this.material.parseMaterial());
        if (this.glow) {
            item.addEnchant(Enchantment.ARROW_DAMAGE, 1);
            ItemMeta itemMeta = item.toItemStack().getItemMeta();
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.toItemStack().setItemMeta(itemMeta);
        }
        item.setName(Color.translate((CommandSender)player, this.name));
        this.lore.forEach(s -> item.addLoreLine(Color.translate((CommandSender)player, s.replace("%item%", this.name).replace("%cost%", String.valueOf(this.cost)).replace("%price%", String.valueOf(this.cost)))));
        item.setDurability(this.data);
        item.setSkullOwner(this.skullOwner);
        return item.toItemStack();
    }

    public void handlePurchase(Player player) {
        LocaleManager locale = SimpleGems.getInstance().getManager(LocaleManager.class);
        if (SimpleGemsAPI.INSTANCE.hasGems(player, this.cost)) {
            SimpleGemsAPI.INSTANCE.takeGems(player, this.cost);
            if (this.action) {
                this.runActions(player);
            } else {
                this.runCommands(player);
            }
            this.sendMessage(player);
        } else {
            locale.sendMessage((CommandSender)player, "not-enough-gems", Placeholders.setPlaceholders((CommandSender)player));
        }
    }

    public XMaterial getMaterial() {
        return this.material;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSkulls() {
        return this.skulls;
    }

    public boolean isHeadDatabase() {
        return this.headDatabase;
    }

    public boolean isMessageEnabled() {
        return this.messageEnabled;
    }

    public boolean isBroadcastMessage() {
        return this.broadcastMessage;
    }

    public boolean isCustomData() {
        return this.customData;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public boolean isAction() {
        return this.action;
    }

    public int getData() {
        return this.data;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public long getCost() {
        return this.cost;
    }
}

