/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.menu;

import me.refracdevelopment.simplegems.SimpleGems;
import me.refracdevelopment.simplegems.utilities.ItemBuilder;
import me.refracdevelopment.simplegems.utilities.chat.Color;
import me.refracdevelopment.simplegems.utilities.config.Menus;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class GemShopGUI
implements Listener {
    private String homeTitle;
    private int homeSize;

    public GemShopGUI() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SimpleGems.getInstance());
    }

    public void openInventory(Player player) {
        this.homeTitle = Color.translate((CommandSender)player, Menus.GEM_SHOP_TITLE);
        this.homeSize = Menus.GEM_SHOP_SIZE;
        Inventory inv = Bukkit.createInventory(null, (int)this.homeSize, (String)this.homeTitle);
        SimpleGems.getInstance().getGemShop().getItems().values().forEach(item -> inv.setItem(item.getSlot(), item.getItem(player)));
        for (int i = 0; i < this.homeSize; ++i) {
            if (inv.getItem(i) != null) continue;
            String name = Menus.GEM_SHOP_FILL_NAME;
            Material material = Menus.GEM_SHOP_FILL_MATERIAL;
            int data = Menus.GEM_SHOP_FILL_DATA;
            ItemBuilder item2 = new ItemBuilder(material);
            item2.setName(Color.translate((CommandSender)player, name));
            item2.setDurability(data);
            inv.setItem(i, item2.toItemStack());
        }
        player.openInventory(inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(this.homeTitle)) {
            event.setCancelled(true);
            SimpleGems.getInstance().getGemShop().getItems().values().forEach(item -> {
                if (item.getSlot() == event.getRawSlot()) {
                    item.handlePurchase(player);
                }
            });
        }
    }
}

