/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.refracdevelopment.simplegems.data.Profile;
import org.bukkit.entity.Player;

public class ProfileManager {
    private Map<UUID, Profile> profiles = new HashMap<UUID, Profile>();

    public void handleProfileCreation(UUID uuid, String name) {
        if (!this.profiles.containsKey(uuid)) {
            this.profiles.put(uuid, new Profile(uuid, name));
        }
    }

    public Profile getProfile(Object object) {
        if (object instanceof Player) {
            Player target = (Player)object;
            if (!this.profiles.containsKey(target.getUniqueId())) {
                return null;
            }
            return this.profiles.get(target.getUniqueId());
        }
        if (object instanceof UUID) {
            UUID uuid = (UUID)object;
            if (!this.profiles.containsKey(uuid)) {
                return null;
            }
            return this.profiles.get(uuid);
        }
        if (object instanceof String) {
            return this.profiles.values().stream().filter(profile -> profile.getPlayerName().equalsIgnoreCase(object.toString())).findFirst().orElse(null);
        }
        return null;
    }

    public Map<UUID, Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Map<UUID, Profile> profiles) {
        this.profiles = profiles;
    }
}

