/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.commands.command;

import java.util.Collections;
import java.util.List;
import me.refracdevelopment.simplegems.api.SimpleGemsAPI;
import me.refracdevelopment.simplegems.manager.LocaleManager;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.CommandContext;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommand;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandWrapper;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.Optional;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.RoseExecutable;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;
import me.refracdevelopment.simplegems.utilities.Methods;
import me.refracdevelopment.simplegems.utilities.chat.Placeholders;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class TakeCommand
extends RoseCommand {
    public TakeCommand(RosePlugin rosePlugin, RoseCommandWrapper parent) {
        super(rosePlugin, parent, new Class[0]);
    }

    @RoseExecutable
    public void execute(CommandContext context, OfflinePlayer target, double amount, @Optional String silent) {
        LocaleManager locale = this.rosePlugin.getManager(LocaleManager.class);
        if (context.getArgs()[1].contains("-")) {
            return;
        }
        if (target.isOnline()) {
            StringPlaceholders placeholders = StringPlaceholders.builder().addAll(Placeholders.setPlaceholders(context.getSender())).add("player", target.getName()).add("gems", String.valueOf(amount)).add("gems_formatted", Methods.format(amount)).add("gems_decimal", Methods.formatDec(amount)).build();
            if (!SimpleGemsAPI.INSTANCE.hasGems(target.getPlayer(), amount)) {
                locale.sendMessage(context.getSender(), "invalid-gems", placeholders);
                return;
            }
            SimpleGemsAPI.INSTANCE.takeGems(target.getPlayer(), amount);
            locale.sendMessage(context.getSender(), "gems-taken", placeholders);
            if (silent != null && silent.equalsIgnoreCase("-s")) {
                return;
            }
            locale.sendMessage((CommandSender)target.getPlayer(), "gems-lost", placeholders);
        } else if (!target.isOnline() && target.hasPlayedBefore()) {
            StringPlaceholders placeholders = StringPlaceholders.builder().addAll(Placeholders.setPlaceholders(context.getSender())).add("player", target.getName()).add("gems", String.valueOf(amount)).add("gems_formatted", Methods.format(amount)).add("gems_decimal", Methods.formatDec(amount)).build();
            if (!SimpleGemsAPI.INSTANCE.hasOfflineGems(target, amount)) {
                locale.sendMessage(context.getSender(), "invalid-gems", placeholders);
                return;
            }
            SimpleGemsAPI.INSTANCE.takeOfflineGems(target, amount);
            locale.sendMessage(context.getSender(), "gems-taken", placeholders);
        } else {
            locale.sendMessage(context.getSender(), "invalid-player");
        }
    }

    @Override
    protected String getDefaultName() {
        return "take";
    }

    @Override
    protected List<String> getDefaultAliases() {
        return Collections.singletonList("remove");
    }

    @Override
    public String getDescriptionKey() {
        return "command-take-description";
    }

    @Override
    public String getRequiredPermission() {
        return "simplegems.command.take";
    }
}

