/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.commands.command;

import me.refracdevelopment.simplegems.api.SimpleGemsAPI;
import me.refracdevelopment.simplegems.manager.LocaleManager;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.CommandContext;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommand;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandWrapper;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.Optional;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.RoseExecutable;
import me.refracdevelopment.simplegems.rosegarden.utils.StringPlaceholders;
import me.refracdevelopment.simplegems.utilities.Methods;
import me.refracdevelopment.simplegems.utilities.chat.Placeholders;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class SetCommand
extends RoseCommand {
    public SetCommand(RosePlugin rosePlugin, RoseCommandWrapper parent) {
        super(rosePlugin, parent, new Class[0]);
    }

    @RoseExecutable
    public void execute(CommandContext context, OfflinePlayer target, double amount, @Optional String silent) {
        LocaleManager locale = this.rosePlugin.getManager(LocaleManager.class);
        if (context.getArgs()[1].contains("-")) {
            return;
        }
        if (target.isOnline()) {
            SimpleGemsAPI.INSTANCE.setGems(target.getPlayer(), amount);
            StringPlaceholders placeholders = StringPlaceholders.builder().addAll(Placeholders.setPlaceholders(context.getSender())).add("player", target.getName()).add("gems", String.valueOf(amount)).add("gems_formatted", Methods.format(amount)).add("gems_decimal", Methods.formatDec(amount)).build();
            locale.sendMessage(context.getSender(), "gems-set", placeholders);
            if (silent != null && silent.equalsIgnoreCase("-s")) {
                return;
            }
            locale.sendMessage((CommandSender)target.getPlayer(), "gems-setted", placeholders);
        } else if (!target.isOnline() && target.hasPlayedBefore()) {
            SimpleGemsAPI.INSTANCE.setOfflineGems(target, amount);
            StringPlaceholders placeholders = StringPlaceholders.builder().addAll(Placeholders.setPlaceholders(context.getSender())).add("player", target.getName()).add("gems", String.valueOf(amount)).add("gems_formatted", Methods.format(amount)).add("gems_decimal", Methods.formatDec(amount)).build();
            locale.sendMessage(context.getSender(), "gems-set", placeholders);
        } else {
            locale.sendMessage(context.getSender(), "invalid-player", Placeholders.setPlaceholders(context.getSender()));
        }
    }

    @Override
    protected String getDefaultName() {
        return "set";
    }

    @Override
    public String getDescriptionKey() {
        return "command-set-description";
    }

    @Override
    public String getRequiredPermission() {
        return "simplegems.command.set";
    }
}

