/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.commands.command;

import java.util.Collections;
import java.util.List;
import me.refracdevelopment.simplegems.api.SimpleGemsAPI;
import me.refracdevelopment.simplegems.manager.LocaleManager;
import me.refracdevelopment.simplegems.rosegarden.RosePlugin;
import me.refracdevelopment.simplegems.rosegarden.command.framework.CommandContext;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommand;
import me.refracdevelopment.simplegems.rosegarden.command.framework.RoseCommandWrapper;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.Optional;
import me.refracdevelopment.simplegems.rosegarden.command.framework.annotation.RoseExecutable;
import me.refracdevelopment.simplegems.utilities.chat.Placeholders;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PayCommand
extends RoseCommand {
    public PayCommand(RosePlugin rosePlugin, RoseCommandWrapper parent) {
        super(rosePlugin, parent, new Class[0]);
    }

    @RoseExecutable
    public void execute(CommandContext context, OfflinePlayer target, double amount, @Optional String silent) {
        LocaleManager locale = this.rosePlugin.getManager(LocaleManager.class);
        if (context.getArgs()[1].contains("-")) {
            return;
        }
        if (!(context.getSender() instanceof Player)) {
            locale.sendMessage(context.getSender(), "no-console", Placeholders.setPlaceholders(context.getSender()));
            return;
        }
        Player player = (Player)context.getSender();
        if (target.isOnline()) {
            SimpleGemsAPI.INSTANCE.payGems(player, target.getPlayer(), amount, silent != null && silent.equals("-s"));
        } else if (!target.isOnline() && target.hasPlayedBefore()) {
            SimpleGemsAPI.INSTANCE.payOfflineGems(player, target, amount);
        } else {
            locale.sendMessage((CommandSender)player, "invalid-player", Placeholders.setPlaceholders((CommandSender)player));
        }
    }

    @Override
    protected String getDefaultName() {
        return "pay";
    }

    @Override
    protected List<String> getDefaultAliases() {
        return Collections.singletonList("send");
    }

    @Override
    public String getDescriptionKey() {
        return "command-pay-description";
    }

    @Override
    public String getRequiredPermission() {
        return "simplegems.command.pay";
    }
}

