/*
 * Decompiled with CFR 0.152.
 */
package me.refracdevelopment.simplegems.api;

import me.refracdevelopment.simplegems.SimpleGems;
import me.refracdevelopment.simplegems.api.events.impl.GemsAddEvent;
import me.refracdevelopment.simplegems.api.events.impl.GemsPayEvent;
import me.refracdevelopment.simplegems.api.events.impl.GemsRemoveEvent;
import me.refracdevelopment.simplegems.api.events.impl.GemsSetEvent;
import me.refracdevelopment.simplegems.data.ProfileData;
import me.refracdevelopment.simplegems.utilities.Methods;
import me.refracdevelopment.simplegems.utilities.Tasks;
import me.refracdevelopment.simplegems.utilities.chat.Color;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class SimpleGemsAPI {
    public static SimpleGems plugin = SimpleGems.getInstance();
    public static SimpleGemsAPI INSTANCE;

    public SimpleGemsAPI() {
        INSTANCE = this;
        Color.log("&aSimpleGemsAPI has been enabled!");
        Color.log("&aWiki & Download: https://simplegems.refracdev.ml/");
    }

    public static boolean isRegistered() {
        return INSTANCE != null;
    }

    public ProfileData getProfileData(Player player) {
        return plugin.getProfileManager().getProfile(player.getUniqueId()).getData();
    }

    public double getGems(Player player) {
        if (this.getProfileData(player) == null) {
            return 0.0;
        }
        return this.getProfileData(player).getGems().getAmount();
    }

    public double getOfflineGems(OfflinePlayer player) {
        return Methods.getOfflineGems(player);
    }

    public void giveGemsItem(Player player, int amount) {
        if (this.getProfileData(player) == null) {
            return;
        }
        Methods.giveGemsItem(player, amount);
    }

    public ItemStack getGemsItem(double amount) {
        return Methods.getGemsItem(amount);
    }

    public boolean hasGems(Player player, double amount) {
        if (this.getProfileData(player) == null) {
            return false;
        }
        return this.getProfileData(player).getGems().hasAmount(amount);
    }

    public boolean hasOfflineGems(OfflinePlayer player, double amount) {
        return Methods.hasOfflineGems(player, amount);
    }

    public void giveGems(Player player, double amount) {
        if (this.getProfileData(player) == null) {
            return;
        }
        GemsAddEvent event = new GemsAddEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.getProfileData(player).getGems().incrementAmount(amount);
        Tasks.runAsync(plugin, () -> this.getProfileData(player).save());
    }

    public void giveOfflineGems(OfflinePlayer player, double amount) {
        Methods.giveOfflineGems(player, amount);
    }

    public void takeGems(Player player, double amount) {
        if (this.getProfileData(player) == null) {
            return;
        }
        GemsRemoveEvent event = new GemsRemoveEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.getProfileData(player).getGems().decrementAmount(amount);
        Tasks.runAsync(plugin, () -> this.getProfileData(player).save());
    }

    public void takeOfflineGems(OfflinePlayer player, double amount) {
        Methods.takeOfflineGems(player, amount);
    }

    public void setGems(Player player, double amount) {
        if (this.getProfileData(player) == null) {
            return;
        }
        GemsSetEvent event = new GemsSetEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.getProfileData(player).getGems().setAmount(amount);
        Tasks.runAsync(plugin, () -> this.getProfileData(player).save());
    }

    public void setOfflineGems(OfflinePlayer player, double amount) {
        Methods.setOfflineGems(player, amount);
    }

    public void payGems(Player player, Player target, double amount, boolean silent) {
        GemsPayEvent event = new GemsPayEvent(player, target, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        Methods.payGems(player, target, amount, silent);
    }

    public void payOfflineGems(Player player, OfflinePlayer target, double amount) {
        Methods.payOfflineGems(player, target, amount);
    }

    public void withdrawGems(Player player, double amount) {
        GemsRemoveEvent event = new GemsRemoveEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        Methods.withdrawGems(player, amount);
    }
}

