/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.util.actions.actions.misc;

import com.google.common.primitives.Floats;
import java.util.LinkedList;
import java.util.List;
import me.gabytm.util.actions.Action;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class PlaySound
implements Action {
    final List<String> sounds = new LinkedList<String>();

    public PlaySound() {
        for (Sound sound : Sound.values()) {
            this.sounds.add(sound.name());
        }
    }

    @Override
    public String getID() {
        return "sound";
    }

    @Override
    public String getDescription() {
        return "Play a sound at player's location, 'volume' and 'pitch' are optional";
    }

    @Override
    public String getUsage() {
        return "[sound] SOUND_NAME volume pitch";
    }

    @Override
    public void run(Player player, String data) {
        if (!data.contains(" ")) {
            return;
        }
        String[] parts = data.toUpperCase().split(" ");
        if (!this.sounds.contains(parts[0])) {
            return;
        }
        Sound sound = Sound.valueOf((String)parts[0]);
        Float volume = parts.length > 1 ? Floats.tryParse((String)parts[1]) : null;
        Float pitch = parts.length > 2 ? Floats.tryParse((String)parts[2]) : null;
        player.playSound(player.getLocation(), sound, volume == null ? 0.0f : volume.floatValue(), pitch == null ? 1.0f : pitch.floatValue());
    }
}

