/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.util.actions;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SplittableRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.clip.placeholderapi.PlaceholderAPI;
import me.gabytm.util.actions.Action;
import me.gabytm.util.actions.actions.command.ConsoleCommand;
import me.gabytm.util.actions.actions.command.PermissionCommand;
import me.gabytm.util.actions.actions.command.PlayerCommand;
import me.gabytm.util.actions.actions.message.ActionBarMessage;
import me.gabytm.util.actions.actions.message.BroadcastMessage;
import me.gabytm.util.actions.actions.message.CenterBroadcastMessage;
import me.gabytm.util.actions.actions.message.CenterChatMessage;
import me.gabytm.util.actions.actions.message.ChatMessage;
import me.gabytm.util.actions.actions.message.JsonMessage;
import me.gabytm.util.actions.actions.message.PermissionBroadcastMessage;
import me.gabytm.util.actions.actions.message.PlayerChat;
import me.gabytm.util.actions.actions.misc.CloseInventory;
import me.gabytm.util.actions.actions.misc.PlaySound;
import me.gabytm.util.actions.utils.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ActionManager {
    private final Map<String, Action> actions = new HashMap<String, Action>();
    private final Pattern RANDOM_PATTERN = Pattern.compile("\\{random:(?<values>((\\d+),?)+)}");
    private final Plugin plugin;

    public ActionManager(Plugin plugin, boolean defaults) {
        this.plugin = plugin;
        if (defaults) {
            this.loadDefaults();
        }
    }

    public ActionManager(Plugin plugin) {
        this(plugin, true);
    }

    private String replacePlaceholders(Player player, String line) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)StringUtil.color(line.trim()));
        }
        return StringUtils.replace((String)StringUtil.color(line.trim()), (String)"%player_name%", (String)player.getName());
    }

    private String replaceTags(String line) {
        Matcher randomMatcher = this.RANDOM_PATTERN.matcher(line);
        while (randomMatcher.find()) {
            List numbers = Stream.of(randomMatcher.group("values").split(",")).map(Ints::tryParse).filter(Objects::nonNull).collect(Collectors.toList());
            int number = 0;
            if (numbers.size() == 1) {
                number = (Integer)numbers.get(0);
            } else if (numbers.size() == 2) {
                number = new SplittableRandom().nextInt((Integer)numbers.get(0), (Integer)numbers.get(1) + 1);
            } else if (numbers.size() > 2) {
                number = (Integer)numbers.get(new SplittableRandom().nextInt(numbers.size()));
            }
            line = StringUtils.replace((String)line, (String)randomMatcher.group(0), (String)Integer.toString(number));
        }
        return line;
    }

    private void executeAction(Player player, String data) {
        String line = this.replaceTags(this.replacePlaceholders(player, data));
        if (!line.contains(" ")) {
            Action Action2 = this.getAction(StringUtils.substringBetween((String)line, (String)"[", (String)"]"));
            if (Action2 == null) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)line);
                return;
            }
            Action2.run(player, line);
            return;
        }
        String[] parts = line.split(" ", 2);
        Action Action3 = this.getAction(StringUtils.substringBetween((String)parts[0], (String)"[", (String)"]"));
        if (Action3 == null) {
            return;
        }
        Action3.run(player, parts[1]);
    }

    public void loadDefaults() {
        Stream.of(new ActionBarMessage(), new BroadcastMessage(), new CenterBroadcastMessage(), new CenterChatMessage(), new ChatMessage(), new ConsoleCommand(this.plugin), new CloseInventory(), new JsonMessage(this.plugin), new PermissionBroadcastMessage(), new PermissionCommand(this.plugin), new PlayerChat(this.plugin), new PlayerCommand(this.plugin), new PlaySound()).forEach(action -> this.register((Action)action, true));
    }

    public void register(Action action, boolean override) {
        String id = (action.getID() == null ? action.getClass().getSimpleName() : action.getID()).toUpperCase();
        if (override) {
            if (this.actions.get(id) != null) {
                this.plugin.getLogger().warning("[ActionUtil] Overriding the action with ID '" + id + "'");
            }
            this.actions.put(id, action);
            action.getAliases().forEach(alias -> this.actions.put(alias.toUpperCase(), action));
        } else {
            this.actions.putIfAbsent(id, action);
            action.getAliases().forEach(alias -> this.actions.putIfAbsent(alias.toUpperCase(), action));
        }
    }

    public void unregister(String id, boolean aliases) {
        Action Action2 = this.getAction(id);
        if (Action2 == null) {
            return;
        }
        this.actions.remove(id);
        if (!aliases || Action2.getAliases().size() == 0) {
            return;
        }
        for (String alias : Action2.getAliases()) {
            Action act = this.actions.get(alias);
            if (act == null || !act.getID().equals(Action2.getID()) || !act.getAliases().equals(Action2.getAliases()) || !act.getDescription().equals(Action2.getDescription())) continue;
            this.actions.remove(alias);
        }
    }

    public void unregister(String action) {
        this.unregister(action, true);
    }

    public void unregister(List<String> actions, boolean aliases) {
        for (String action : actions) {
            if (action == null) continue;
            this.unregister(action, aliases);
        }
    }

    public void unregister(List<String> actions) {
        this.unregister(actions, true);
    }

    public void unregister(boolean aliases, String ... actions) {
        this.unregister(Arrays.asList(actions), aliases);
    }

    public void unregister(String ... actions) {
        this.unregister(Arrays.asList(actions), true);
    }

    public void unregisterAll() {
        this.actions.clear();
    }

    public void execute(Player player, String action) {
        Bukkit.getScheduler().runTask(this.plugin, () -> this.executeAction(player, action));
    }

    public void executeAsync(Player player, String action) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> this.executeAction(player, action));
    }

    public void execute(Player player, List<String> actions) {
        actions.forEach(action -> this.execute(player, (String)action));
    }

    public void executeAsync(Player player, List<String> actions) {
        actions.forEach(action -> this.executeAsync(player, (String)action));
    }

    public void execute(Player player, String ... actions) {
        this.execute(player, Arrays.asList(actions));
    }

    public void executeAsync(Player player, String ... actions) {
        this.executeAsync(player, Arrays.asList(actions));
    }

    public Action getAction(String id) {
        return this.actions.get(id.toUpperCase());
    }

    public Map<String, Action> getActions() {
        return ImmutableMap.copyOf(this.actions);
    }
}

