package me.zafiro93.signlog.events;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

import me.zafiro93.signlog.SignLog;

public class SignChange implements Listener {
	
	SignLog plugin;
	
	public SignChange(SignLog plugin) {
		this.plugin = plugin;
	}
	
	@EventHandler
    public void onSignChange(SignChangeEvent e) {
        Player p = e.getPlayer();
        String worldName = p.getLocation().getWorld().getName();
        
        List<String> excludedWorlds = plugin.getConfig().getStringList("excluded-worlds");
        boolean logConsole = plugin.getConfig().getBoolean("log-console");
        
        if (!excludedWorlds.contains(worldName)) {
            Block b = e.getBlock();
            Date now = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String msg = e.getLine(0) + " " + e.getLine(1) + " " + e.getLine(2) + " " + e.getLine(3);
            Location loc = b.getLocation();
            String coords = loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ();

            SignLog.logToFile("[" + format.format(now) + "] " + p.getName() + " <> " + worldName + " <> " + coords + " <> " + msg);

            if (logConsole == true) {
            	plugin.log.info("[SignLog] [" + format.format(now) + "] " + p.getName() + " <> " + worldName + " <> " + coords + " <> " + msg);
            }
        }
    }
}
