package me.zafiro93.signlog.events;

import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

import me.zafiro93.signlog.SignLog;

public class BadWordsCheck implements Listener {
	
	SignLog plugin;

	public BadWordsCheck(SignLog plugin) {
		this.plugin = plugin;
	}
    
    @EventHandler
    public void badWordsCheck(SignChangeEvent e) {
        Player p = e.getPlayer();
        String worldName = p.getLocation().getWorld().getName();
        
        List<String> excludedWorlds = plugin.getConfig().getStringList("excluded-worlds");
        List<String> badWords = plugin.getConfig().getStringList("bad-words");
        boolean notifications = plugin.getConfig().getBoolean("staff-notifications");
        boolean punish = plugin.getConfig().getBoolean("punish");
        String kickMsg = plugin.getConfig().getString("kick-msg");
        boolean logConsole = plugin.getConfig().getBoolean("log-console");

        if (!excludedWorlds.contains(worldName)) {
            for (int z = 0; z < badWords.toArray().length; ++z) {
                if ((e.getLine(0).contains(badWords.get(z))) || (e.getLine(1).contains(badWords.get(z))) || (e.getLine(2).contains(badWords.get(z))) || (e.getLine(3).contains(badWords.get(z)))) {
                    Block b = e.getBlock();

                    Location loc = b.getLocation();
                    String coords = loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ();

                    if (notifications == true) {
                        for (Player staff : Bukkit.getOnlinePlayers()) {
                            if (staff.hasPermission("signlog.notify") || p.isOp()) {
                                staff.sendMessage("§8[§4§lSignLog§8] §c" + p.getName() + " §8➔ §cSIGN §8➔ §cBad Words §8➔ §7World: §f" + worldName + " §7CC: §f" + coords);
                            }
                        }
                    }
                    
                    if (logConsole == true) {
                    	plugin.log.info("[SignLog] " + p.getName() + " <> SIGN <> Bad Words <> World: " + worldName + "<> CC: §f" + coords);
                    }

                    if (punish == true) {
                        p.kickPlayer(ChatColor.translateAlternateColorCodes('&', kickMsg));
                    }
                }
            }
        }
    }
}