package me.zafiro93.signlog;

import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

import me.zafiro93.signlog.events.BadWordsCheck;
import me.zafiro93.signlog.events.SignChange;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDate;
import java.util.logging.Logger;

public class SignLog extends JavaPlugin implements Listener {
	
	public Logger log;
	public static SignLog instance;

    public SignLog() {
        log = Bukkit.getLogger();
    }

    public void onEnable() {
    	instance = this;
        createConfig();
        registerEvents();
        this.saveConfig();
		loadConfiguration();
        log.info("[" + getDescription().getName() + "] v" + getDescription().getVersion() + " has been enabled!");
    }

    public void onDisable() {
        log.info("[" + getDescription().getName() + "] v" + getDescription().getVersion() + " has been disabled!");
    }

    public void registerEvents() {
        this.getServer().getPluginManager().registerEvents(new SignChange(this), this);
        this.getServer().getPluginManager().registerEvents(new BadWordsCheck(this), this);
    }
    
    private void createConfig() {
		try {
			if (!getDataFolder().exists()) {
				getDataFolder().mkdirs();
			}
			File file = new File(getDataFolder(), "config.yml");
			if (!file.exists()) {
				getLogger().info("Config.yml not found, creating!");
				saveDefaultConfig();
			} else {
				getLogger().info("Config.yml found, loading!");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
    
    public void loadConfiguration() {
	     getConfig().options().copyDefaults(true);
	     saveConfig();
	}
    
    public static void logToFile(String message) {
        try {
            File logsFolder = new File(getFolder(), "logs");
            if (!logsFolder.exists()) {
            	logsFolder.mkdir();
            }
            
            LocalDate date = LocalDate.now();
            int day = date.getDayOfMonth();
            int month = date.getMonthValue();
            int year = date.getYear();
            String fileName = year + "-" + month + "-" + day + ".log";
            
            File saveTo = new File(logsFolder + File.separator + fileName);
            		
            if (!saveTo.exists()) {
                saveTo.createNewFile();
            }

            FileWriter fw = new FileWriter(saveTo, true);
            PrintWriter pw = new PrintWriter(fw);

            pw.println(message);
            pw.flush();
            pw.close();

        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    
    private static File getFolder() {
    	return SignLog.instance.getDataFolder();
    }
}