/*
 * Decompiled with CFR 0.152.
 */
package net.mackenziemolloy.shopguiplus.sellgui.utility.sirblobman;

import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

public final class VersionUtility {
    @NotNull
    public static String getMinecraftVersion() {
        String bukkitVersion = Bukkit.getBukkitVersion();
        int firstDash = bukkitVersion.indexOf(45);
        return bukkitVersion.substring(0, firstDash);
    }

    @NotNull
    public static String getNetMinecraftServerVersion() {
        Server server = Bukkit.getServer();
        Class<?> serverClass = server.getClass();
        Package serverPackage = serverClass.getPackage();
        String serverPackageName = serverPackage.getName();
        int lastPeriodIndex = serverPackageName.lastIndexOf(46);
        int nextIndex = lastPeriodIndex + 2;
        return serverPackageName.substring(nextIndex);
    }

    @NotNull
    public static String getMajorMinorVersion() {
        String minecraftVersion = VersionUtility.getMinecraftVersion();
        int lastPeriodIndex = minecraftVersion.lastIndexOf(46);
        return lastPeriodIndex < 2 ? minecraftVersion : minecraftVersion.substring(0, lastPeriodIndex);
    }

    public static int getMajorVersion() {
        String majorMinorVersion = VersionUtility.getMajorMinorVersion();
        int periodIndex = majorMinorVersion.indexOf(46);
        String majorString = majorMinorVersion.substring(0, periodIndex);
        return Integer.parseInt(majorString);
    }

    public static int getMinorVersion() {
        String majorMinorVersion = VersionUtility.getMajorMinorVersion();
        int periodIndex = majorMinorVersion.indexOf(46);
        int nextIndex = periodIndex + 1;
        String minorString = majorMinorVersion.substring(nextIndex);
        return Integer.parseInt(minorString);
    }

    static {
        String bukkitVersion = Bukkit.getBukkitVersion();
        if (bukkitVersion.contains("-pre") || bukkitVersion.contains("-rc")) {
            Logger logger = Bukkit.getLogger();
            logger.warning("[ShopGUIPlus-SellGUI] You are using a '-pre' or '-rc' version of spigot.");
            logger.warning("[ShopGUIPlus-SellGUI] Bugs may occur when using a preview version.");
        }
    }
}

